<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Comment extends Base_Action {

    public $comment = [];
    
    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'comment';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-save-comments';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Add Comment', 'e-addons');
    }

    public function get_pid() {
        return 10883;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_save_comment_override', [
            'label' => esc_html__('Add or Update', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'add' => [
                    'title' => esc_html__('Add', 'e-addons'),
                    'icon' => 'eicon-plus',
                ],
                'update' => [
                    'title' => esc_html__('Update', 'e-addons'),
                    'icon' => 'eicon-sync',
                ],
            ],
            'default' => 'add',
            'toggle' => false,
            'description' => esc_html__('Updated data of a Comment or create a new one', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_type_comment_comment', [
            'label' => esc_html__('Find Comment to update', 'e-addons'),
            'type' => 'e-query',
            'placeholder' => esc_html__('Find a Comment', 'e-addons'),
            'label_block' => true,
            'query_type' => 'comments',
            'description' => esc_html__('Search Comment or leave empty for last Comment.', 'e-addons'),
            'condition' => [
                'e_form_save_comment_override' => 'update',
            ],
                ]
        );

        $widget->add_control(
                'e_form_save_type_comment_heading', [
            'label' => esc_html__('Comment', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);
        $widget->add_control(
                'e_form_save_type_comment_content', [
            'label' => esc_html__('Comment Content', 'e-addons'),
            'type' => Controls_Manager::WYSIWYG,
            'rows' => 2,
            'default' => '[field id="message"]',
            'description' => esc_html__('Use field Shortcode for Content', 'e-addons'),
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_comment_author', [
            'label' => esc_html__('Author Name', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="name"]',
            'description' => esc_html__('Use field Shortcode for Name or leave empty for logged User Name', 'e-addons'),
            'condition' => [
                'e_form_save_comment_override' => 'add',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_comment_author_email', [
            'label' => esc_html__('Author Email', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="email"]',
            'description' => esc_html__('Use field Shortcode for Email or leave empty for logged User Email', 'e-addons'),
            'condition' => [
                'e_form_save_comment_override' => 'add',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_comment_author_url', [
            'label' => esc_html__('Author Url', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Use field Shortcode for Url or leave empty for logged User Url', 'e-addons'),
            'condition' => [
                'e_form_save_comment_override' => 'add',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_comment_approved', [
            'label' => esc_html__('Comment Approved', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'e_form_save_comment_override' => 'add',
            ],
                ]
        );
        $widget->add_control(
                'e_form_save_type_comment_type', [
            'label' => esc_html__('Comment Type', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => 'comment',
            'condition' => [
                'e_form_save_comment_override' => 'add',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_comment_replytocom', [
            'label' => esc_html__('Reply To Comment', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_save_comment_override' => 'add',
            ],
            'label_block' => 'true',
                ]
        );



        $widget->add_control(
                'e_form_save_comment_file', [
            'label' => esc_html__('Save Files as Media', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Create a Media and save his ID instead the URL', 'e-addons'),
                ]
        );
        $widget->add_control(
                'e_form_save_comment_array', [
            'label' => esc_html__('Save Multiple as Array', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Save Files, Select and Checkboxes submitted value as Array instead a comma separated values string', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_comment_extra', [
            'label' => esc_html__('Add Extra data', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Add extra User info, like IP, referrer and current ID', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $post_id = intval($_POST['post_id']);
        $queried_id = intval($_POST['queried_id']);
        $form_id = sanitize_key($_POST['form_id']);
        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);

        if (!empty($settings['e_form_save_comment_extra'])) {
            $fields = Form::get_form_data($record, false, true, $settings);
        }

        $comment_id = false;

        $fields = $this->fields_filter($fields);
        
        $this->comment = array();
        if ($settings['e_form_save_type_comment_content']) {
            $this->comment['comment_content'] = $settings['e_form_save_type_comment_content'];
        }
        $fields = $this->set_wp_obj_fields($fields);
        
        // get ID                
        if ($settings['e_form_save_type_comment_comment']) {
            $comment_id = $this->get_wp_obj_id($settings['e_form_save_type_comment_comment'], 'comment', $ajax_handler);
            if (!$comment_id) {
                return false;
            }
        }
        if (!$comment_id || $settings['e_form_save_comment_override'] == 'add') {
            // ADD NEW
            $this->comment['comment_author'] = $settings['e_form_save_type_comment_author'];
            $this->comment['comment_author_email'] = $settings['e_form_save_type_comment_author_email'];
            $this->comment['comment_author_url'] = $settings['e_form_save_type_comment_author_url'];
            $current_user_id = get_current_user_id();
            $current_user = get_user_by('ID', $current_user_id);
            if ($current_user && !is_wp_error($current_user)) {
                $this->comment['user_id'] = $current_user->ID;
                $this->comment['comment_author'] = empty($this->comment['comment_author']) ? $current_user->display_name : $this->comment['comment_author'];
                $this->comment['comment_author_email'] = empty($this->comment['comment_author_email']) ? $current_user->user_email : $this->comment['comment_author_email'];
                $this->comment['comment_author_url'] = empty($this->comment['comment_author_url']) ? $current_user->comment_author_url : $this->comment['comment_author_url'];
            }
            $this->comment['comment_type'] = $settings['e_form_save_type_comment_type'];
            $this->comment['comment_post_ID'] = $queried_id;
            $this->comment['comment_approved'] = empty($settings['e_form_save_type_comment_approved']) ? 0 : 1;
            $this->comment['comment_parent'] = intval($settings['e_form_save_type_comment_replytocom']);
            //comment_karma	int [0]
            $comment_id = wp_insert_comment($this->comment);
        } else {
            // UPDATE
            if (!empty($this->comment)) {
                $comment = get_comment($comment_id);
                $this->comment['comment_ID'] = $comment_id;
                $ret = wp_update_comment($this->comment);
                if (is_wp_error($ret)) {
                    $comment_id = $ret;
                }
            }
        }
        
        /**
	 * Fires immediately after a comment is inserted into the database.
	 *
	 * @since 2.8.0
	 *
	 * @param int        $id      The comment ID.
	 * @param WP_Comment $comment Comment object.
	 */
        $comment = get_comment($comment_id);
	do_action( 'e_addons/forms/add_comment', $comment_id, $comment, $fields );


        if (is_wp_error($comment_id)) {
            $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
        }

        if ($comment_id) {
            Form::save_extra($comment_id, 'comment', $settings, $fields);
        } else {
            $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
        }
    }

}