<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Cookie extends Base_Action {

    public function get_description() {
        return esc_html__('Add Cookie Actions to Elementor PRO Form', 'e-addons');
    }

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'cookie';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Cookie', 'e-addons');
    }
    
    public function get_icon() {
        return 'eadd-el-form-pro-act-coookie';
    }

    public function get_pid() {
        return 274;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_cookie_ignore_empty', [
            'label' => esc_html__('Ignore Empty fields', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Do not save empty fields, this limit DB size consuption', 'e-addons'),
                ]
        );
        
        $widget->add_control(
                'e_form_cookie_ignore_exist', [
            'label' => esc_html__('Ignore Existent Cookies', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Do not save the Cookie if a Cookie with same name already exists', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_cookie_fields', [
            'label' => esc_html__('Form Fields', 'e-addons'),
            'type' => 'form_fields',//Controls_Manager::SELECT2,
            'description' => esc_html__('Leave empty to save ALL fields as Cookies', 'e-addons'),
            //'options' => [],
            'multiple' => true,
            'label_block' => 'true',
                ]
        );

        $widget->add_control(
                'e_form_cookie_expire', [
            'label' => esc_html__('Expire days', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'description' => esc_html__('Specify how long the cookie expires, how long is the Cookie life', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_cookie_path', [
            'label' => esc_html__('Path', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '/',
            'description' => esc_html__('Specify cookie server path ', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_cookie_domain', [
            'label' => esc_html__('Domain', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            //'default' => $_SERVER['HTTP_HOST'] == 'localhost' ? '' : $_SERVER['HTTP_HOST'],
            'description' => esc_html__('Specify cookie domain name ', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {
        $fields = Form::get_form_data($record, false);
        $settings = $this->get_settings(true, $fields);

        if ($settings['e_form_cookie_ignore_empty']) {
            $tmp = array();
            if (!empty($fields) && is_array($fields)) {
                foreach ($fields as $akey => $adata) {
                    if ($adata != '') {
                        $tmp[$akey] = $adata;
                    }
                }
            }
            $fields = $tmp;
        }

        if (!empty($fields) && is_array($fields)) {
            if (!empty($settings['e_form_cookie_fields']) && is_array($settings['e_form_cookie_fields'])) {
                $settings['e_form_cookie_fields'] = array_filter($settings['e_form_cookie_fields']); // remove the "No field" empty value
            }
            foreach ($fields as $akey => $adata) {
                if (!empty($settings['e_form_cookie_fields']) && !in_array($akey, $settings['e_form_cookie_fields']))
                    continue;

                if ($settings['e_form_cookie_ignore_exist'] && !empty($_COOKIE[$akey]))
                    continue;
                
                $cookie_days = ($settings['e_form_cookie_expire']) ? time() + (86400 * $settings['e_form_cookie_expire']) : 0; // 86400 = 1 day
                $http_host = $_SERVER['HTTP_HOST'] == 'localhost' ? '' : $_SERVER['HTTP_HOST'];
                $e_form_cookie_domain = empty($settings['e_form_cookie_domain']) ? $http_host : $settings['e_form_cookie_domain'];
                $e_form_cookie_path = empty($settings['e_form_cookie_path']) ? '/' : $settings['e_form_cookie_path'];
                @setcookie($akey, $adata, $cookie_days, $e_form_cookie_path, $e_form_cookie_domain);
            }
        }
    }

}
