<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Email extends Base_Action {

    public $attachments = array();
    public $body = '';
    public $body_txt = '';
    
    public function __construct() {
        parent::__construct();

        add_filter( 'elementor_pro/forms/wp_mail_message', [$this, 'wp_mail_message'] );
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-send-custom-mail';
    }

    public function get_pid() {
        return 279;
    }

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'e-email';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Advanced Email', 'e-addons');
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);
        
        /* translators: %s: Site title. */
        $default_message = sprintf( esc_html__( 'New message from "%s"', 'elementor-pro' ), get_option( 'blogname' ) );

        $repeater_fields = new \Elementor\Repeater();
        $repeater_fields->add_control(
                'e_form_email_enable',
                [
                    'label' => esc_html__('Enable email', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'separator' => 'after',
                ]
        );
        $repeater_fields->add_control(
                'e_form_email_condition_field', [
            'label' => esc_html__('Condition Field', 'e-addons'),
            'type' => 'form_fields',
            'label_block' => true,
                ]
        );
        $repeater_fields->add_control(
                'e_form_email_condition_status', [
            'label' => esc_html__('Condition Status', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => $this->operator_options,
            'default' => 'not_empty',
            'condition' => [
                'e_form_email_condition_field!' => '',
            ],
                ]
        );
        $repeater_fields->add_control(
                'e_form_email_condition_value', [
            'label' => esc_html__('Condition Value', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'condition' => [
                'e_form_email_condition_field!' => '',
                'e_form_email_condition_status' => $this->operator_with_value,
            ],
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_subject',
                [
                    'label' => esc_html__('Subject', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => $default_message,
                    'placeholder' => $default_message,
                    'label_block' => true,
                    'render_type' => 'none',
                    'separator' => 'before',
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_to',
                [
                    'label' => esc_html__('To', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => get_option('admin_email'),
                    'placeholder' => get_option('admin_email'),
                    'label_block' => true,
                    'title' => esc_html__('Separate emails with commas', 'elementor-pro'),
                    'render_type' => 'none',
                    'separator' => 'before',
                ]
        );

        $site_domain = \ElementorPro\Core\Utils::get_site_domain();
        $repeater_fields->add_control(
                'e_form_email_from',
                [
                    'label' => esc_html__('From Email', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => 'email@' . $site_domain,
                    'render_type' => 'none',
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_from_name',
                [
                    'label' => esc_html__('From Name', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => get_bloginfo('name'),
                    'render_type' => 'none',
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_reply_to',
                [
                    'label' => esc_html__('Reply-To', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'render_type' => 'none',
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_to_cc',
                [
                    'label' => esc_html__('Cc', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => '',
                    'title' => esc_html__( 'Separate emails with commas', 'elementor-pro' ),
                    'render_type' => 'none',
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_to_bcc',
                [
                    'label' => esc_html__('Bcc', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => '',
                    'title' => esc_html__( 'Separate emails with commas', 'elementor-pro' ),
                    'render_type' => 'none',
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_content_type',
                [
                    'label' => esc_html__('Send As', 'elementor-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'html',
                    'render_type' => 'none',
                    'options' => [
                        'html' => esc_html__( 'HTML', 'elementor-pro' ),
                        'plain' => esc_html__( 'Plain', 'elementor-pro' ),
                    ],
                    'separator' => 'before',
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_content_type_advanced', [
            'label' => esc_html__('Email body', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'text' => [
                    'title' => esc_html__('Text Editor', 'e-addons'),
                    'icon' => 'eicon-text',
                ],
                'template' => [
                    'title' => esc_html__('Custom Template', 'e-addons'),
                    'icon' => 'eicon-library-open',
                ]
            ],
            'toggle' => false,
            'default' => 'text',
            'condition' => [
                'e_form_email_content_type' => 'html',
            ],
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_content',
                [
                    'label' => esc_html__('Message', 'elementor-pro'),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => '[all-fields]',
                    'placeholder' => '[all-fields]',
                    'description' => $default_message,
                    'label_block' => true,
                    'render_type' => 'none',
                    'condition' => [
                        'e_form_email_content_type_advanced' => 'text',
                    ],
                ]
        );

        $repeater_fields->add_control(
                'e_form_email_content_template',
                [
                    'label' => esc_html__('Select Template', 'e-addons'),
                    'type' => 'e-query',
                    'placeholder' => esc_html__('Find Email Template', 'e-addons'),
                    'label_block' => true,
                    'query_type' => 'posts',
                    'object_type' => 'elementor_library',
                    'description' => esc_html__('Generate email body from an Elementor Template', 'e-addons'),
                    'condition' => [
                        'e_form_email_content_type' => 'html',
                        'e_form_email_content_type_advanced' => 'template',
                    ],
                ]
        );
        $repeater_fields->add_control(
                'e_form_email_content_template_layout', [
            'label' => esc_html__('Force CSS Table styles', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
            'description' => esc_html__('Increase compatibility with old email Client', 'e-addons'),
            'condition' => [
                'e_form_email_content_type' => 'html',
                'e_form_email_content_type_advanced' => 'template',
            ],
                ]
        );
        $repeater_fields->add_control(
                'e_form_attachments',
                [
                    'label' => esc_html__('Add uploaded files as email attachments', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'separator' => 'before',
                ]
        );
        $repeater_fields->add_control(
                'e_form_attachments_fields',
                [
                    'label' => esc_html__('Attachment fields', 'e-addons'),
                    'type' => 'form_fields',
                    'field_type' => 'attachment',
                    'multiple' => true,
                    'description' => esc_html__('Leave empty to attach all File/Media fields', 'e-addons'),
                    'condition' => [
                        'e_form_attachments!' => '',
                    ],
                ]
        );
        $repeater_fields->add_control(
                'e_form_attachments_delete',
                [
                    'label' => esc_html__('Remove uploaded files after sending emails', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'description' => esc_html__('Delete all files uploaded from the server after being sent as attachments', 'e-addons'),
                    'condition' => [
                        'e_form_attachments!' => '',
                    ],
                ]
        );
        $repeater_fields->add_control(
                'e_form_attachments_file',
                [
                    'label' => esc_html__('Add custom attachments', 'e-addons'),
                    'type' => 'file',
                    'description' => esc_html__('Send selected Files as Email Attachments', 'e-addons'),
                    'multiple' => true,
                ]
        );

        $widget->add_control(
                'e_form_email_repeater', [
            'label' => esc_html__('Emails', 'e-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'title_field' => '{{{ e_form_email_subject }}}',
            'fields' => $repeater_fields->get_controls(),
            'description' => esc_html__('Send all Email you need', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     * 
     * Extend the basic Email Action
     * /elementor-pro/modules/forms/actions/email.php
     */
    public function run($record, $ajax_handler) {

        global $phpmailer;
        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);

        $delete = false;
        if (!empty($settings['e_form_email_repeater'])) {
            foreach ($settings['e_form_email_repeater'] as $mkey => $mail) {

                $this->body = $this->body_txt = '';
                $this->attachments = array();

                if ($mail['e_form_email_enable']) {

                    $check = true;
                    $field_name = $mail['e_form_email_condition_field'];
                    if (!empty($field_name)) {
                        $field_value = $fields[$field_name];
                        $field_type = Form::get_field_type($field_name, $settings);
                        if ($field_type == 'checkbox') {
                            $field_value = Utils::explode($field_value);
                        }
                        $check = $this->check_condition($field_value, $mail['e_form_email_condition_status'], $mail['e_form_email_condition_value']);
                    }

                    if ($check) {

                        $template = (!empty($mail['e_form_email_content_type_advanced']) && $mail['e_form_email_content_type_advanced'] == 'template');
                        $send_html = 'plain' !== $mail['e_form_email_content_type'] || $template;
                        $line_break = $send_html ? '<br />' : "\n";

                        $site_domain = \ElementorPro\Core\Utils::get_site_domain();
                        $fields_mail = [
                            'e_form_email_to' => get_option('admin_email'),
                            /* translators: %s: Site title. */
                            'e_form_email_subject' => sprintf(__('New message from "%s"', 'elementor-pro'), get_bloginfo('name')),
                            'e_form_email_content' => '[all-fields]',
                            'e_form_email_from_name' => get_bloginfo('name'),
                            'e_form_email_from' => 'wordpress@' . $site_domain, //get_bloginfo('admin_email'),
                            'e_form_email_reply_to' => 'noreplay@' . $site_domain,
                            'e_form_email_to_cc' => '',
                            'e_form_email_to_bcc' => '',
                        ];

                        foreach ($fields_mail as $key => $default) {
                            $setting = trim($mail[$key]);
                            //if (!empty($setting)) {
                                $fields_mail[$key] = $setting;
                            //}
                        }

                        $headers = sprintf('From: %s <%s>' . "\r\n", $fields_mail['e_form_email_from_name'], $fields_mail['e_form_email_from']);

                        $email_reply_to = $this->get_reply_to( $fields_mail );                      
                        $headers .= sprintf('Reply-To: %s' . "\r\n", $email_reply_to);

                        $headers .= 'Content-Type: text/' . ($send_html ? 'html' : 'plain') . '; charset=UTF-8' . "\r\n";

                        if (!empty($fields_mail['e_form_email_to_cc'])) {
                            $headers .= 'Cc: ' . $fields_mail['e_form_email_to_cc'] . "\r\n";
                        }

                        if (!empty($fields_mail['e_form_email_to_bcc'])) {
                            $headers .= 'Bcc: ' . $fields_mail['e_form_email_to_bcc'] . "\r\n";
                        }

                        /**
                         * Email headers.
                         *
                         * Filters the additional headers sent when the form send an email.
                         *
                         * @since 1.0.0
                         *
                         * @param string|array $headers Additional headers.
                         */
                        $headers = apply_filters('elementor_pro/forms/wp_mail_headers', $headers);

                        /**
                         * Email content.
                         *
                         * Filters the content of the email sent by the form.
                         *
                         * @since 1.0.0
                         *
                         * @param string $email_content Email content.
                         */
                        $altbody = false;
                        if ($template) {
                            $template_id = $mail['e_form_email_content_template'];
                            if (!$template_id) {
                                continue;
                            }
                            // using a template
                            $atts = array();
                            $atts['css'] = true;
                            $current_user_id = get_current_user_id();
                            if ($current_user_id) {
                                $atts['user_id'] = $current_user_id;
                            }
                            if (get_the_ID()) {
                                $atts['post_id'] = get_the_ID();
                            }
                            $this->body = \EAddonsForElementor\Core\Managers\Template::e_template($template_id, $atts);
                            $this->replace_data($fields, $record, $line_break);
                            $this->add_style($mail);
                        } else {
                            $settings_raw = $record->get('form_settings');
                            $this->body = $settings_raw['e_form_email_repeater'][$mkey]['e_form_email_content'];
                            $this->replace_data($fields, $record, $line_break);
                            $this->body_txt = Form::get_plain_txt($this->body);
                            if ($send_html) {
                                $altbody = add_action('phpmailer_init', [$this, 'set_phpmailer_altbody']);
                            } else {
                                $this->body = $this->body_txt;
                            }
                        }
                        
                        $this->body = apply_filters('elementor_pro/forms/wp_mail_message', $this->body);
                        
                        //var_dump($_POST); die();
                        //$phpmailer->AltBody = $this->body_txt;                                       
                        if (!empty($mail['e_form_attachments'])) {
                            $this->attachments = Form::get_attachments($fields, $settings, $mail, $this->body);
                            //var_dump($this->attachments); die();
                        }

                        $email_sent = wp_mail($fields_mail['e_form_email_to'], $fields_mail['e_form_email_subject'], $this->body, $headers, $this->attachments);

                        $phpmailer = null; // reset the mailer
                        if ($altbody) {
                            remove_action('phpmailer_init', [$this, 'set_phpmailer_altbody']);
                        }

                        /**
                         * Elementor form mail sent.
                         *
                         * Fires when an email was sent successfully.
                         *
                         * @since 1.0.0
                         *
                         * @param array       $settings Form settings.
                         * @param Form_Record $record   An instance of the form record.
                         */
                        do_action('elementor_pro/forms/mail_sent', $mail, $record);

                        if ($email_sent) {
                            if ($mail['e_form_attachments'] && $mail['e_form_attachments_delete']) {
                                $delete = true;
                            }
                        } else {
                            $message = \ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message('server_error', $mail);
                            $ajax_handler->add_error_message( $message );
                            throw new \Exception( $message );
                        }

                    }
                }
            }

            if ($delete && $ajax_handler->is_success) {
                foreach ($settings['e_form_email_repeater'] as $mkey => $mail) {
                    if (!empty($mail['e_form_attachments'])) {
                        Form::delete_attachments($fields, $settings, $mail);
                    }
                }
            }
        }
    }

    /*
     * Add AltBody to Email
     */
    public function set_phpmailer_altbody($phpmailer) {
        $phpmailer->AltBody = $this->body_txt;
    }

    /*
     * Add CSS inline to Template and increase Client compatibility
     */
    public function add_style($mail) {
        $css = Utils::get_extra_css($mail['e_form_email_content_template']);
        if (!empty($mail['e_form_email_content_template_layout']) && $mail['e_form_email_content_template_layout'] != 'flex') {
            $css .= '.elementor-section .elementor-container { display: table !important; width: 100% !important; } .elementor-row { display: table-row !important; } .elementor-column { display: table-cell !important; } .elementor-widget-wrap { display: block !important; }';
        }
        $cssToInlineStyles = new \TijsVerkoyen\CssToInlineStyles\CssToInlineStyles();
        $this->body = $cssToInlineStyles->convert($this->body, $css);
    }
    
    public function wp_mail_message($email_content) {
        $fields = Form::get_form_data();
        $settings = $this->get_settings(true, $fields);
        $this->body = $email_content;
        $this->replace_data($fields); //, $record);
        return $this->body;
    }

    public function replace_data($fields, $record = false, $line_break = '<br>') {
        $this->body = Form::replace_content_shortcodes($this->body, $fields, $line_break);
        $this->body = Form::do_setting_shortcodes($this->body, $fields);
        $this->body = Utils::get_dynamic_data($this->body, $fields, 'form');
    }
    
    protected function get_reply_to( $fields ) {
            $email_reply_to  = '';
            if ( ! empty( $fields['e_form_email_reply_to'] ) ) {
                if (filter_var($fields['e_form_email_reply_to'], FILTER_VALIDATE_EMAIL)) {
                    $email_reply_to = $fields['e_form_email_reply_to'];
                }
            }
            //var_dump($fields['e_form_email_reply_to']); var_dump($email_reply_to); die();
            if ( empty( $email_reply_to ) ) {
                if (filter_var($fields['e_form_email_from'], FILTER_VALIDATE_EMAIL)) {
                    $email_reply_to = $fields['e_form_email_from'];
                }
            }            
            return $email_reply_to;
    }

}
