<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Lost_Password extends Base_Action {

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'lost-password';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-lostpassword';
    }

    public function get_pid() {
        return 8853;
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Lost Password Reset', 'e-addons');
    }

    /* public function get_pid() {
      return 273;
      } */

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_lost_password_user_login', [
            'label' => esc_html__('UserName or Email Address', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="email"]',
            'placeholder' => '[field id="user_login"]',
            'description' => esc_html__('Use field Shortcode for UserName or Email', 'e-addons'),
            'label_block' => 'true',
                ]
        );

        $widget->add_control(
                'e_form_lost_password_user_pass', [
            'label' => esc_html__('User Password', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            //'default' => '[field id="user_pass"]',
            'description' => esc_html__('Use field Shortcode (like [field id="pwd"]) for Password, leave empty to send Reset Email, fill it for User password update', 'e-addons'),
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_lost_password_user_pass_confirmation', [
            'label' => esc_html__('User Password Confirmation', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Use field Shortcode for Password Confirmation or leave empty to use single password', 'e-addons'),
            'condition' => [
                'e_form_lost_password_user_pass!' => '',
            ],
            'label_block' => 'true',
                ]
        );


        $widget->add_control(
                'e_form_lost_password_user_key', [
            'label' => esc_html__('Password Reset Key', 'e-addons'),
            'description' => esc_html__('Use the field Shortcode for Reset Key, it should be filled with the related GET url param'),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_lost_password_user_pass!' => '',
            ],
            'label_block' => 'true',
                ]
        );


        $widget->add_control(
                'e_form_lost_password_email_heading', [
            'label' => esc_html__('Reset Email', 'e-addons'),
            'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
            'condition' => [
                'e_form_lost_password_user_pass' => '',
            ],
        ]);
        
        $site_domain = \ElementorPro\Core\Utils::get_site_domain();
        $widget->add_control(
                'e_form_lost_password_from',
                [
                    'label' => esc_html__('From Email', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => 'email@' . $site_domain,
                    'render_type' => 'none',
                    
                    'condition' => [
                        'e_form_lost_password_user_pass' => '',
                    ],
                ]
        );
        $widget->add_control(
                'e_form_lost_password_from_name',
                [
                    'label' => esc_html__('From Name', 'elementor-pro'),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => get_bloginfo('name'),
                    'render_type' => 'none',
                    'condition' => [
                        'e_form_lost_password_user_pass' => '',
                    ],
                ]
        );
        $widget->add_control(
                'e_form_lost_password_custom_title', [
            'label' => esc_html__('Custom Email Subject', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Leave empty to use the Wordpress default one', 'e-addons'),
            'condition' => [
                'e_form_lost_password_user_pass' => '',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_lost_password_template', [
            'label' => esc_html__('Use Custom Email Template', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,            
            'condition' => [
                'e_form_lost_password_user_pass' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_form_lost_password_custom_template',
                [
                    'label' => esc_html__('Select Template', 'e-addons'),
                    'type' => 'e-query',
                    'placeholder' => esc_html__('Find Email Template', 'e-addons'),
                    'label_block' => true,
                    'query_type' => 'posts',
                    'object_type' => 'elementor_library',
                    'description' => esc_html__('Generate email body from an Elementor Template', 'e-addons'),
                    'condition' => [
                        'e_form_lost_password_user_pass' => '',
                        'e_form_lost_password_template!' => '',
                    ],
                ]
        );
        $widget->add_control(
                'e_form_lost_password_custom_message', [
            'label' => esc_html__('Custom Email Message', 'e-addons'),
            'type' => Controls_Manager::WYSIWYG,            
            'condition' => [
                'e_form_lost_password_user_pass' => '',
                'e_form_lost_password_template' => '',
            ],
                ]
        );
        if (Utils::is_plugin_active('woocommerce')) {
            $widget->add_control(
                    'e_form_lost_password_woo_message', [
                'label' => esc_html__('Use WooCommerce Template', 'e-addons'),
                'type' => Controls_Manager::SWITCHER, 
                'condition' => [
                    'e_form_lost_password_user_pass' => '',
                    'e_form_lost_password_template' => '',
                    'e_form_lost_password_custom_message' => '',                    
                ],
                    ]
            );
        }
        $widget->add_control(
                'e_form_lost_password_shortcodes', [
            'type' => Controls_Manager::RAW_HTML,      
            'raw' => esc_html__('Leave empty to use Wordpress default reset password email body. Use shortcode [URL] (or [KEY]) to generate the unique URL inside the email.', 'e-addons'),
            'condition' => [
                'e_form_lost_password_user_pass' => '',
            ],
                ]
        );
        
        $widget->add_control(
                'e_form_lost_password_custom_url', [
            'label' => esc_html__('Custom Reset Page', 'e-addons'),
            'type' => Controls_Manager::URL,
            'description' => esc_html__('Set a Custom page instead Wordpress built-in', 'e-addons'),
            'condition' => [
                'e_form_lost_password_user_pass' => '',
            ],
            'label_block' => 'true',
                ]
        );


        $widget->add_control(
                'e_form_lost_password_error_heading', [
            'label' => esc_html__('Errors', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);


        $widget->add_control(
                'e_form_lost_password_user_login_error', [
            'label' => esc_html__('Login Not Valid Error', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Please enter a valid username or email address.', 'e-addons'),
            'condition' => [
                'e_form_lost_password_user_login!' => '',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_lost_password_user_key_error', [
            'label' => esc_html__('Reset KEY Mismatch Error', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'placeholder' => esc_html__('Sorry, Reset KEY not match', 'e-addons'),
            'condition' => [
                //'e_form_save_user_override' => 'add',
                'e_form_lost_password_user_pass!' => '',
                'e_form_lost_password_user_key!' => '',
            ],
            'label_block' => 'true',
                ]
        );

        $widget->add_control(
                'e_form_lost_password_user_pass_confirmation_error', [
            'label' => esc_html__('User Password Mismatch Error', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('The passwords do not match.'), // WP
            'condition' => [
                //'e_form_save_user_override' => 'add',
                'e_form_lost_password_user_pass!' => '',
                'e_form_lost_password_user_pass_confirmation!' => '',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_lost_password_error_stop', [
            'label' => esc_html__('Stop Actions on Error', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Stop next actions execution on Error', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);
        $settings_raw = $this->get_settings(false);

        $user_data = false;
        $login = trim(wp_unslash($settings['e_form_lost_password_user_login']));
        if (strpos($login, '@')) {
            $user_data = get_user_by('email', $login);
        }
        if (!$user_data) {
            $user_data = get_user_by('login', $login);
        }
        if (empty($user_data)) {
            $error_msg = $settings['e_form_lost_password_user_login_error'];
            $ajax_handler->add_error_message($error_msg);
            if (!empty($settings['e_form_lost_password_error_stop'])) {
                $ajax_handler->send();
                die();
            }
        } else {

            if ($settings['e_form_lost_password_user_pass']) {

                // RESET PASSWORD
                $error = false;
                if ($settings_raw['e_form_lost_password_user_pass_confirmation']) {
                    if ($settings['e_form_lost_password_user_pass'] != $settings['e_form_lost_password_user_pass_confirmation']) {
                        // not same password
                        $error_msg = $settings['e_form_lost_password_user_pass_confirmation_error'];
                        $ajax_handler->add_error_message($error_msg);
                        $error = true;
                        if (!empty($settings['e_form_lost_password_error_stop'])) {
                            $ajax_handler->send();
                            die();
                        }
                    }
                }

                //$key = get_password_reset_key($user_data);
                $user_check = check_password_reset_key($settings['e_form_lost_password_user_key'], $user_data->user_login);
                //var_dump($user_check); die();
                if (is_wp_error($user_check)) {
                    $error_msg = $settings['e_form_lost_password_user_key_error'] ? $settings['e_form_lost_password_user_key_error'] : Utils::to_string($user_check->get_error_messages());
                    $ajax_handler->add_error_message($error_msg);
                    $error = true;
                    if (!empty($settings['e_form_lost_password_error_stop'])) {
                        $ajax_handler->send();
                        die();
                    }
                }

                if (!$error) {
                    /**
                     * Fires before the password reset procedure is validated.
                     *
                     * @since 3.5.0
                     *
                     * @param WP_Error         $errors WP Error object.
                     * @param WP_User|WP_Error $user   WP_User object if the login and reset key match. WP_Error object otherwise.
                     */
                    //do_action('validate_password_reset', $errors, $user_data);

                    reset_password($user_data, $settings['e_form_lost_password_user_pass']);
                    //wp_set_password($settings['e_form_lost_password_user_pass'], $user_data->ID);
                }
            } else {

                // SEND RESET EMAIL
                //include_once(ABSPATH.'wp-login.php');
                //$errors = retrieve_password();
                $errors = $this->retrieve_password($settings, $user_data);

                if (is_wp_error($errors)) {
                    //var_dump($errors);
                    $error_msg = Utils::to_string($errors->get_error_messages());
                    $ajax_handler->add_error_message($error_msg);
                    if (!empty($settings['e_form_lost_password_error_stop'])) {
                        $ajax_handler->send();
                        die();
                    }
                }
            }
        }
    }

    /**
     * Handles sending password retrieval email to user.
     *
     * @since 2.5.0
     *
     * @return bool|WP_Error True: when finish. WP_Error on error
     */
    public function retrieve_password($settings = array(), $user_data = false) {
        $errors = new \WP_Error();

        /**
         * Fires before errors are returned from a password reset request.
         *
         * @since 2.1.0
         * @since 4.4.0 Added the `$errors` parameter.
         * @since 5.4.0 Added the `$user_data` parameter.
         *
         * @param WP_Error      $errors    A WP_Error object containing any errors generated
         *                                 by using invalid credentials.
         * @param WP_User|false $user_data WP_User object if found, false if the user does not exist.
         */
        do_action('lostpassword_post', $errors, $user_data);

        /**
         * Filters the errors encountered on a password reset request.
         *
         * The filtered WP_Error object may, for example, contain errors for an invalid
         * username or email address. A WP_Error object should always be returned,
         * but may or may not contain errors.
         *
         * If any errors are present in $errors, this will abort the password reset request.
         *
         * @since 5.5.0
         *
         * @param WP_Error      $errors    A WP_Error object containing any errors generated
         *                                 by using invalid credentials.
         * @param WP_User|false $user_data WP_User object if found, false if the user does not exist.
         */
        $errors = apply_filters('lostpassword_errors', $errors, $user_data);

        if ($errors->has_errors()) {
            return $errors;
        }

        if (!$user_data) {
            $errors->add('invalidcombo', esc_html__('<strong>Error</strong>: There is no account with that username or email address.'));
            return $errors;
        }

        // Redefining user_login ensures we return the right case in the email.
        $user_id = $user_data->ID;
        $user_login = $user_data->user_login;
        $user_email = $user_data->user_email;
        $key = get_password_reset_key($user_data);

        if (is_wp_error($key)) {
            return $key;
        }

        if (is_multisite()) {
            $site_name = get_network()->site_name;
        } else {
            /*
             * The blogname option is escaped with esc_html on the way into the database
             * in sanitize_option we want to reverse this for the plain text arena of emails.
             */
            $site_name = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
        }


        if (!empty($settings['e_form_lost_password_custom_url']['url'])) {
            $reset_url = $settings['e_form_lost_password_custom_url']['url'];
            $reset_url = add_query_arg('action', 'rp', $reset_url);
            $reset_url = add_query_arg('key', $key, $reset_url);
            $reset_url = add_query_arg('login', rawurlencode($user_login), $reset_url);
            $reset_url = add_query_arg('email', rawurlencode($user_email), $reset_url);
        } else {
            $reset_url = network_site_url("wp-login.php?action=rp&key=$key&login=" . rawurlencode($user_login), 'login');
        }

        $headers = '';

        if (!empty($settings['e_form_lost_password_from']) || !empty($settings['e_form_lost_password_from_name'])) {
            if (empty($settings['e_form_lost_password_from'])) {
                $site_domain = \ElementorPro\Core\Utils::get_site_domain();
                $settings['e_form_lost_password_from'] = 'email@' . $site_domain;
            }
            if (empty($settings['e_form_lost_password_from_name'])) {
                $settings['e_form_lost_password_from_name'] = get_bloginfo('name');
            }
            $headers = sprintf('From: %s <%s>' . "\r\n", $settings['e_form_lost_password_from_name'], $settings['e_form_lost_password_from']);
        }
        
        $custom = false;
        if (empty($settings['e_form_lost_password_template'] )) {
            if (!empty($settings['e_form_lost_password_custom_message'] )) {
                $custom = $settings['e_form_lost_password_custom_message'];
            }
        } else {
            if (!empty($settings['e_form_lost_password_custom_template'])) {
                // using a template
                $atts = array();
                $atts['css'] = true;
                $custom = \EAddonsForElementor\Core\Managers\Template::e_template($settings['e_form_lost_password_custom_template'], $atts);
                $css = Utils::get_extra_css($settings['e_form_lost_password_custom_template']);
                $css .= '.elementor-section .elementor-container { display: table !important; width: 100% !important; } .elementor-row { display: table-row !important; } .elementor-column { display: table-cell !important; } .elementor-widget-wrap { display: block !important; }';                
                $cssToInlineStyles = new \TijsVerkoyen\CssToInlineStyles\CssToInlineStyles();
                $custom = $cssToInlineStyles->convert($custom, $css);
            }
        }

        $title = false;
        $message = false;
        if (!empty($custom )) {
            $message = $custom;
            $message = str_replace('[URL]', $reset_url, $message);
            $message = str_replace('[KEY]', $key, $message);
            $headers .= 'Content-Type: text/html; charset=UTF-8' . "\r\n";
        } else {            
            if (Utils::is_plugin_active('woocommerce') && !empty($settings['e_form_lost_password_woo_message'])) {                
                
                //$woo = \WC();
                //$woo->includes();
                //include_once WC_ABSPATH . 'includes/class-wc-emails.php';
                $wc_email = new \WC_Emails();
                $wc_email->init();
                if (class_exists('\WC_Email_Customer_Reset_Password')) {
                    $wc_email_reset = new \WC_Email_Customer_Reset_Password();
                    $wc_email_reset->user_id = $user_id;
                    $wc_email_reset->user_login = $user_login;
                    $wc_email_reset->user_email = $user_email;
                    $wc_email_reset->reset_key = $key;
                    $title = $wc_email_reset->get_subject();
                    $message = $wc_email_reset->get_content_html();                    
                    if (!empty($settings['e_form_lost_password_custom_url']['url'])) {
                        $woo_reset_url = esc_url( add_query_arg( array( 'key' => $key, 'id' => $user_id ), wc_get_endpoint_url( 'lost-password', '', wc_get_page_permalink( 'myaccount' ) ) ) );
                        $message = str_replace($woo_reset_url, $reset_url, $message);
                    }                 
                    $message = apply_filters( 'woocommerce_mail_content', $wc_email_reset->style_inline( $message ) );
                    $headers .= 'Content-Type: text/html; charset=UTF-8' . "\r\n";
                }
            }
            if (empty($message)) {
                $message = esc_html__('Someone has requested a password reset for the following account:') . "\r\n\r\n";
                /* translators: %s: Site name. */
                $message .= sprintf(__('Site Name: %s'), $site_name) . "\r\n\r\n";
                /* translators: %s: User login. */
                $message .= sprintf(__('Username: %s'), $user_login) . "\r\n\r\n";
                $message .= esc_html__('If this was a mistake, just ignore this email and nothing will happen.') . "\r\n\r\n";
                $message .= esc_html__('To reset your password, visit the following address:') . "\r\n\r\n";
                $message .= $reset_url; // . "\r\n";
            }
        }
        //echo $message; die();//var_dump($title); die();//
        
        if (!empty($settings['e_form_lost_password_custom_title'])) {
            $title = $settings['e_form_lost_password_custom_title'];
        } else {
            if (!$title) {
                /* translators: Password reset notification email subject. %s: Site title. */
                $title = sprintf(__('[%s] Password Reset'), $site_name);
            }
        }

        /**
         * Filters the subject of the password reset email.
         *
         * @since 2.8.0
         * @since 4.4.0 Added the `$user_login` and `$user_data` parameters.
         *
         * @param string  $title      Default email title.
         * @param string  $user_login The username for the user.
         * @param WP_User $user_data  WP_User object.
         */
        $title = apply_filters('retrieve_password_title', $title, $user_login, $user_data);

        /**
         * Filters the message body of the password reset mail.
         *
         * If the filtered message is empty, the password reset email will not be sent.
         *
         * @since 2.8.0
         * @since 4.1.0 Added `$user_login` and `$user_data` parameters.
         *
         * @param string  $message    Default mail message.
         * @param string  $key        The activation key.
         * @param string  $user_login The username for the user.
         * @param WP_User $user_data  WP_User object.
         */
        $message = apply_filters('retrieve_password_message', $message, $key, $user_login, $user_data);
        //echo $message; die(); var_dump($user_email); var_dump(wp_specialchars_decode($title)); var_dump($headers); die();
        if ($message && !wp_mail($user_email, wp_specialchars_decode($title), $message, $headers)) {
            $errors->add(
                    'retrieve_password_email_failure',
                    sprintf(
                            /* translators: %s: Documentation URL. */
                            esc_html__('<strong>Error</strong>: The email could not be sent. Your site may not be correctly configured to send emails. <a href="%s">Get support for resetting your password</a>.'),
                            esc_url(__('https://wordpress.org/support/article/resetting-your-password/'))
                    )
            );
            return $errors;
        }

        return true;
    }

}
