<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Message extends Base_Action {

    public function __construct() {
        parent::__construct();
        add_action("elementor/element/form/section_messages_style/before_section_end", [$this, 'update_controls'], 10, 2);
        //add_action( "elementor/frontend/widget/after_render", [$this, '_print_to_form'] );
        add_action('elementor/widget/render_content', [$this, '_print_to_form'], 10, 2);
        add_filter("elementor/widget/print_template", [$this, '_render_form'], 10, 2);
    }

    public static function get_description() {
        return esc_html__('Add custom Message to Elementor PRO Form', 'e-addons');
    }

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'message';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Message', 'e-addons');
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-message';
    }
    
    public function get_pid() {
        return 3654;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_message_preview',
                [
                    'label' => esc_html__('Preview in Editor', 'e-addons'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                ]
        );
        $widget->add_control(
                'e_message_text', [
            'label' => esc_html__('Message Text', 'e-addons'),
            'type' => Controls_Manager::WYSIWYG,
            'default' => esc_html__('Thanks [field id="name"] to submit this form', 'e-addons'),
            'label_block' => true,
            'separator' => 'before',
                ]
        );
        $widget->add_control(
                'e_message_clear',
                [
                    'label' => esc_html__('Remove default icon', 'e-addons'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message:before' => 'display: none;',
                    ],
                    'separator' => 'before',
                ]
        );
        $widget->add_control(
                'e_message_close', [
            'label' => esc_html__('Add close button to message', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'selectors' => [
                '{{WRAPPER}} .elementor-message' => 'position: relative;',
            ],
            'render_type' => 'template',
                ]
        );
        $widget->add_control(
                'e_message_close_position', [
            'label' => esc_html__('Close button Position', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__('Left', 'e-addons'),
                    'icon' => 'fa fa-align-left',
                ],
                'right' => [
                    'title' => esc_html__('Right', 'e-addons'),
                    'icon' => 'fa fa-align-right',
                ]
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-message-btn-dismiss' => 'position: absolute; top: 0; {{VALUE}}: 0; cursor: pointer;',
            ],
            'toggle' => false,
            'default' => 'right',
            'condition' => [
                'e_message_close!' => '',
            ]
                ]
        );
        
        $widget->add_control(
                'e_message_text_floating',
                [
                    'label' => esc_html__('Floating message', 'e-addons'),
                    'type' => Controls_Manager::SWITCHER,
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message' => 'position: fixed !important; display: block; z-index: 100; bottom: 0;',
                    ],
                    'separator' => 'before',
                ]
        );
        $widget->add_control(
                'e_message_text_floating_align', [
            'label' => esc_html__('Floationg Position', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__('Left', 'e-addons'),
                    'icon' => 'eicon-h-align-left',
                ],
                /* 'center' => [
                  'title' => esc_html__('Center', 'e-addons'),
                  'icon' => 'eicon-h-align-center',
                  ], */
                'right' => [
                    'title' => esc_html__('Right', 'e-addons'),
                    'icon' => 'eicon-h-align-right',
                ],
            ],
            'default' => 'right',
            'selectors' => [
                '{{WRAPPER}} .elementor-message' => '{{VALUE}}: 0;',
            ],
            'condition' => [
                'e_message_text_floating!' => '',
            ],
                ]
        );

        

        $widget->add_control(
                'e_message_hide', [
            'label' => esc_html__('Hide Form after submit', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'separator' => 'before',
                ]
        );
        
        $widget->add_control(
                'warning_message_action',
                [
                    //'label' => esc_html__('WARNING', 'e-addons'),
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => '<b>'.esc_html__('WARNING').'</b><br>'.esc_html__('This action interrupt next actions execution, so set it as last action.', 'e-addons'),
                    'separator' => 'before',
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {
        
        if (defined('E_PAYPAL_IPN')) return;
        
        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);
        //$settings = $this->get_settings(false);
        $this->_message($fields, $settings, $ajax_handler);
    }

    public function _message($fields, $settings, $ajax_handler = false) {
        
        $element_id = $this->get_form_id($settings);

        $message_html = $settings['e_message_text'];
        //$message_html .= var_export($settings, true);
        //$message_html .= '<style>.elementor-form .elementor-message{position: relative;}.elementor-form .elementor-message::before{float: left;}</style>';

        if ($settings['e_message_close']) {
            $message_html .= '<div class="elementor-message-btn-dismiss" onClick="jQuery(this).parent().fadeOut();"><i class="eicon-editor-close" aria-hidden="true"></i></div>';
        }

        /*if ($settings['e_message_text_floating']) {
            $message_html .= '<style>.elementor-element-' . $element_id . ' .elementor-message {position: fixed !important; display: block; z-index: 100; bottom: 0;'.($settings['e_message_text_floating_align'] ? $settings['e_message_text_floating_align'].': 0;' : '').'}</style>';
        }*/
        if (!\Elementor\Plugin::$instance->editor->is_edit_mode()) {
            if ($settings['e_message_hide']) {
                $message_html .= '<style>.elementor-element-' . $element_id . ' .elementor-form-fields-wrapper, .elementor-element-' . $element_id . ' .e-form__indicators {display: none !important;}</style>';
            }
        } else {
            $message_html = '<div class="elementor-message elementor-message-success" role="alert">' . $message_html . '</div>';
        }
        /*
        $message_html = Form::replace_content_shortcodes($message_html, $fields);                    
        $message_html = Form::do_setting_shortcodes($message_html, $fields);
        $message_html = Utils::get_dynamic_data($message_html);
        //$message_html .= var_export($fields, true);
        */
        if (\Elementor\Plugin::$instance->editor->is_edit_mode() && !empty($settings['e_message_preview'])) {
            return $message_html;
        }

        if ($ajax_handler) {
            //$ajax_handler->add_success_message($message_html);
            //$ajax_handler->messages['success'] = array($message_html);
            //$ajax_handler->is_success = true;
            //var_dump($ajax_handler); die();
            if ($ajax_handler->is_success) {                
                wp_send_json_success([
                    'message' => $message_html,
                    'data' => $ajax_handler->data,
                ]);
                die();
            }
            $ajax_handler->add_error_message($message_html);
        }
        return false;
    }

    public function _render_form($content, $element) {
        if ($element->get_name() == 'form') {
            //$content .= $this->_form_message(array(), $element->get_settings());
            return false;
        }
        return $content;
    }

    public function _print_to_form($content, $element) {
        if (\Elementor\Plugin::$instance->editor->is_edit_mode()) {
            if ($element->get_name() == 'form') {
                $content .= $this->_message(array(), $element->get_settings_for_display());
            }
        }
        return $content;
    }

    public function update_controls($element, $args) {

        $element->add_control(
                'success_message_header',
                [
                    'label' => esc_html__('Success Message', 'e-addons'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
        );
        $element->add_responsive_control(
                'success_message_align',
                [
                    'label' => esc_html__('Alignment', 'elementor'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'elementor'),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__('Center', 'elementor'),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'elementor'),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__('Justified', 'elementor'),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-success' => 'text-align: {{VALUE}};',
                    ],
                ]
        );
        $element->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'success_message_bgcolor',
                    'types' => ['classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .elementor-message.elementor-message-success',
                ]
        );
        $element->add_group_control(
                Group_Control_Border::get_type(), [
            'name' => 'success_message_border',
            'selector' => '{{WRAPPER}} .elementor-message.elementor-message-success',
                ]
        );
        $element->add_control(
                'success_message_border_radius',
                [
                    'label' => esc_html__('Border Radius', 'elementor-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-success' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        $element->add_responsive_control(
                'success_message_padding',
                [
                    'label' => esc_html__('Padding', 'elementor-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-success' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        $element->add_responsive_control(
                'success_message_margin',
                [
                    'label' => esc_html__('Margin', 'elementor-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-success' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
        );
        $element->add_responsive_control(
                'success_message_width',
                [
                    'label' => esc_html__('Width', 'elementor'),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'unit' => '%',
                    ],
                    'tablet_default' => [
                        'unit' => '%',
                    ],
                    'mobile_default' => [
                        'unit' => '%',
                    ],
                    'size_units' => ['%', 'px', 'vw'],
                    'range' => [
                        '%' => [
                            'min' => 1,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 1,
                            'max' => 1000,
                        ],
                        'vw' => [
                            'min' => 1,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-success' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'e_message_text_floating!' => '',
                    ]
                ]
        );

        $element->add_control(
                'error_message_header',
                [
                    'label' => esc_html__('Error Message', 'e-addons'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
        );
        $element->add_responsive_control(
                'error_message_align',
                [
                    'label' => esc_html__('Alignment', 'elementor'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'elementor'),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__('Center', 'elementor'),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'elementor'),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__('Justified', 'elementor'),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-error' => 'text-align: {{VALUE}};',
                        '{{WRAPPER}} .elementor-message.elementor-message-danger' => 'text-align: {{VALUE}};',
                    ],
                ]
        );
        $element->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'error_message_bgcolor',
                    'types' => ['classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .elementor-message.elementor-message-error, {{WRAPPER}} .elementor-message.elementor-message-danger',
                ]
        );
        $element->add_group_control(
                Group_Control_Border::get_type(), [
            'name' => 'error_message_border',
            'selector' => '{{WRAPPER}} .elementor-message.elementor-message-error, {{WRAPPER}} .elementor-message.elementor-message-danger',
                ]
        );
        $element->add_control(
                'error_message_border_radius',
                [
                    'label' => esc_html__('Border Radius', 'elementor-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-error' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .elementor-message.elementor-message-danger' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        $element->add_responsive_control(
                'error_message_padding',
                [
                    'label' => esc_html__('Padding', 'elementor-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-error' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .elementor-message.elementor-message-danger' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        $element->add_responsive_control(
                'error_message_margin',
                [
                    'label' => esc_html__('Margin', 'elementor-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-error' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .elementor-message.elementor-message-danger' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
        );
        $element->add_responsive_control(
                'error_message_width',
                [
                    'label' => esc_html__('Width', 'elementor'),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'unit' => '%',
                    ],
                    'tablet_default' => [
                        'unit' => '%',
                    ],
                    'mobile_default' => [
                        'unit' => '%',
                    ],
                    'size_units' => ['%', 'px', 'vw'],
                    'range' => [
                        '%' => [
                            'min' => 1,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 1,
                            'max' => 1000,
                        ],
                        'vw' => [
                            'min' => 1,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-message.elementor-message-error' => 'width: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .elementor-message.elementor-message-danger' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'e_message_text_floating!' => '',
                    ]
                ]
        );
        $element->add_control(
                'inline_message_header',
                [
                    'label' => esc_html__('Inline Message', 'e-addons'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
        );
        $element->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'inline_message_bgcolor',
                    'types' => ['classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .elementor-message.elementor-help-inline',
                ]
        );
        
    }

}
