<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Remote extends Base_Action {

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'remote';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-export';
    }

    public function get_pid() {
        return 272;
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Send to Remote', 'e-addons');
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_remote_url',
                [
                    'label' => esc_html__('Endpoint URL', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => 'https://www.your-site.ext/my-script.php',
                    'label_block' => true,
                ]
        );
        $widget->add_control(
                'e_form_remote_port',
                [
                    'label' => esc_html__('Port', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'placeholder' => '80',
                ]
        );
        $widget->add_control(
                'e_form_remote_method',
                [
                    'label' => esc_html__('Method', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'get' => esc_html__('GET', 'e-addons'),
                        'post' => esc_html__('POST', 'e-addons'),
                        'head' => esc_html__('HEAD', 'e-addons'),
                    ],
                    'default' => 'get',
                ]
        );
        
        $repeater_headers = new \Elementor\Repeater();
        $repeater_headers->add_control(
                'e_form_remote_header_key', [
            'label' => esc_html__('Header Key', 'e-addons'),
            'placeholder' => 'Content-Type',
            'type' => Controls_Manager::TEXT,
                ]
        );
        $repeater_headers->add_control(
                'e_form_remote_header_value', [
            'label' => esc_html__('Header Value', 'e-addons'),
            'placeholder' => 'application/json',
            'type' => Controls_Manager::TEXT,
                ]
        );
        $widget->add_control(
                'e_form_remote_headers', [
            'label' => esc_html__('Headers', 'e-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater_headers->get_controls(),
            'title_field' => '{{{ e_form_remote_header_key }}}: {{{ e_form_remote_header_value }}}',
            'default' => [['e_form_remote_header_key' => 'Connection', 'e_form_remote_header_value' => 'keep-alive']],
            'prevent_empty' => false,
                ]
        );
        
        $widget->add_control(
                'e_form_remote_ssl', [
            'label' => esc_html__('Enable SSL Certificate verify', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
                ]
        );
        $widget->add_control(
                'e_form_remote_empty', [
            'label' => esc_html__('Ignore fields with empty value', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
                ]
        );
        $widget->add_control(
                'e_form_remote_json', [
            'label' => esc_html__('Encode Post Data in Json', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'e_form_remote_method' => 'post',
            ],
                ]
        );
        $repeater_fields = new \Elementor\Repeater();
        $repeater_fields->add_control(
                'e_form_remote_field_key', [
            'label' => esc_html__('Field Key', 'e-addons'),
            'description' => esc_html__('Is the key of the parameter in the request', 'e-addons')
            . '<br>?<b>field_key</b>=FieldValue&<b>page</b>=2&<b>txt</b>=Test<br>',
            'type' => Controls_Manager::TEXT,
                ]
        );
        $repeater_fields->add_control(
                'e_form_remote_field_value', [
            'label' => esc_html__('Field Value', 'e-addons'),
            'description' => esc_html__('Is the value of the parameter in the request', 'e-addons')
            . '<br>?field_key=<b>FieldValue</b>&page=<b>2</b>&txt=<b>Test</b><br>' .
            esc_html__('Can use static text, field Shortcode, Token or mixed', 'e-addons'),
            'type' => Controls_Manager::CODE,
                ]
        );
        $widget->add_control(
                'e_form_remote_fields', [
            'label' => esc_html__('Arguments', 'e-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater_fields->get_controls(),
            //'title_field' => '{{{ e_form_remote_field_key }}}',
            'title_field' => '{{{ e_form_remote_field_key }}} = {{{ e_form_remote_field_value }}}',
            'prevent_empty' => false,
                ]
        );

        $widget->add_control(
                'e_form_remote_log', [
            'label' => esc_html__('Enable log', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Create a log for Export result', 'e-addons'),
            'sperator' => 'before',
            'default' => 'yes',
                ]
        );
        $widget->add_control(
                'e_form_remote_log_path', [
            'label' => esc_html__('Log Path', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => 'elementor/remote/log_' . $widget->get_id() . '_[date|Ymd].txt',
            'description' => esc_html__('The Log path', 'e-addons'),
            'label_block' => true,
            'condition' => [
                'e_form_remote_log!' => '',
            ],
                ]
        );

        $widget->add_control(
                'e_form_remote_error', [
            'label' => esc_html__('Show error on Failure', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '' => esc_html__('None'),
                'yes' => esc_html__('Default'),
                'response' => esc_html__('Response'),
                'custom' => esc_html__('Custom'),
            ],
            'description' => esc_html__('If the remote request fail (not response code 200) then the form return an error to user', 'e-addons'),
            'default' => 'yes',
                ]
        );
        $widget->add_control(
                'e_form_remote_error_field', [
            'label' => esc_html__('Response Sub Field', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'placeholder' => 'message',
            'description' => esc_html__('If the answer to the remote call is in JSON format, then is possible to print a specific subfield of data, type each sub field level separated by a dot (eg: "errors.email").', 'e-addons'),
            'condition' => [
                'e_form_remote_error' => 'response',
            ],
                ]
        );
        $widget->add_control(
                'e_form_remote_error_custom', [
            'label' => esc_html__('Custom error', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'placeholder' => 'Oops, something has gone wrong',
            'condition' => [
                'e_form_remote_error' => 'custom',
            ],
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {
        $fields = Form::get_form_data($record, false);
        $settings = $this->get_settings(true, $fields);

        $remote_data = array();
        if (!empty($settings['e_form_remote_fields'])) {
            foreach ($settings['e_form_remote_fields'] as $akey => $adata) {
                // TOKENIZE parameters repeater
                $pvalue = $adata['e_form_remote_field_value'];
                if ($pvalue == '' && $settings['e_form_remote_empty']) {
                    continue;
                }
                if ((substr(trim($pvalue), 0, 1) == '{' && substr(trim($pvalue), -1, 1) == '}') || (substr(trim($pvalue), 0, 1) == '[' && substr(trim($pvalue), -1, 1) == ']')) {
                    $pvalue = json_decode($pvalue);
                }
                if ($pvalue === 'true' || $pvalue === 'TRUE') {
                    $pvalue = true;
                }
                if ($pvalue === 'false' || $pvalue === 'FALSE') {
                    $pvalue = false;
                }
                $remote_data[$adata['e_form_remote_field_key']] = $pvalue;
            }
        }

        $args = array();
        $exp_url = $settings['e_form_remote_url'];
        if ($exp_url) {
            $pieces = explode('/', $exp_url);
            if (count($pieces) >= 3) {
                if ($settings['e_form_remote_port']) {
                    $pieces[2] = $pieces[2] . ':' . $settings['e_form_remote_port'];
                    $exp_url = implode('/', $pieces);
                }
                if ($settings['e_form_remote_method'] == 'get') {
                    if (!empty($remote_data)) {
                        foreach ($remote_data as $akey => $avalue) {
                            $exp_url = add_query_arg($akey, $avalue, $exp_url);
                        }
                    }
                    /* $args = array(
                      'timeout'     => 5,
                      'redirection' => 5,
                      'httpversion' => '1.0',
                      'user-agent'  => 'WordPress/' . $wp_version . '; ' . home_url(),
                      'blocking'    => true,
                      'headers'     => array(),
                      'cookies'     => array(),
                      'body'        => null,
                      'compress'    => false,
                      'decompress'  => true,
                      'sslverify'   => true,
                      'stream'      => false,
                      'filename'    => null
                      ); */
                } else {
                    if ($settings['e_form_remote_json']) {
                        if (!empty($remote_data)) {
                            foreach ($remote_data as $akey => $avalue) {
                                $remote_data[$akey] = Utils::maybe_json_decode($avalue, true);
                            }
                        }
                        $args['body'] = json_encode($remote_data);
                        $args['headers'] = array('Content-Type' => 'application/json; charset=utf-8');
                        $args['data_format'] = 'body';
                    } else {
                        $args['body'] = $remote_data;
                    }
                    /* $args =
                     * method: POST, 
                     * timeout: 5, 
                     * redirection: 5, 
                     * httpversion: 1.0, 
                     * blocking: true, 
                     * headers: array(), 
                     * body: null, 
                     * cookies: array() */
                }

                if (!empty($settings['e_form_remote_headers'])) {
                    foreach ($settings['e_form_remote_headers'] as $akey => $adata) {
                        // TOKENIZE parameters repeater
                        $args['headers'][$adata['e_form_remote_header_key']] = $adata['e_form_remote_header_value'];
                    }
                }

                if (!$settings['e_form_remote_ssl']) {
                    add_filter('https_ssl_verify', '__return_false');
                }

                $args['follow_redirects'] = true;

                // Send the request
                $req = 'wp_remote_' . $settings['e_form_remote_method'];
                $ret = call_user_func($req, $exp_url, $args);
                $ret_code = wp_remote_retrieve_response_code($ret);
                if ($ret_code < 300) {
                    $log = 'Form sent to remote: OK';
                } else {
                    $log = 'Form NOT sent to remote: ERROR ' . $ret_code;
                    if (!empty($settings['e_form_remote_error'])) {                        
                        switch ($settings['e_form_remote_error']) {
                            case 'yes':
                                $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
                                break;
                            case 'response': 
                                $ret_body = wp_remote_retrieve_body($ret);
                                if (!empty($settings['e_form_remote_error_field'])) {
                                    $ret_body = json_decode($ret_body, true);
                                    $keys = Utils::explode($settings['e_form_remote_error_field'], '.');
                                    $ret_body = Utils::get_array_value($ret_body, $keys);
                                }
                                $ajax_handler->add_error_message(Utils::to_string($ret_body));
                                break;
                            case 'custom': 
                                if (!empty($settings['e_form_remote_error_custom'])) {
                                    $ajax_handler->add_error_message($settings['e_form_remote_error_custom']);
                                } else {
                                    if (!empty($settings['invalid_message'])) {
                                        $ajax_handler->add_error_message($settings['invalid_message']);
                                    } else {
                                        $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
                                    }
                                }
                                break;
                        }
                    }
                }

                if ($settings['e_form_remote_log']) {
                    $ret_body = wp_remote_retrieve_body($ret);
                    $log = $log . ' - ' . $req . PHP_EOL;
                    $log .= 'request_url: ' . $exp_url . PHP_EOL;
                    if ($settings['e_form_remote_method'] == 'post') {
                        $log .= 'request_data: ' . var_export($args['body'], true) . PHP_EOL;
                    }
                    $log .= 'return_body: ' . var_export($ret_body, true);
                    $log = PHP_EOL . '[' . date('Y-m-d H:i:s') . '] ' . $log;

                    $upload = wp_upload_dir();
                    $upload_dir = $upload['basedir'];
                    $log_dir = $upload_dir . '/' . dirname($settings['e_form_remote_log_path']);
                    $log_filename = basename($settings['e_form_remote_log_path']);
                    $log_filename = str_replace('[date|Ymd]', date('Ymd'), $log_filename);
                    if ((!is_dir($log_dir) && !mkdir($log_dir, 0755, true)) || !file_put_contents($log_dir . '/' . $log_filename, $log, FILE_APPEND)) {
                        $ajax_handler->add_error_message('Error on LOG creation in ' . $log_dir . '/' . $log_filename);
                    }
                } 
           }
        }
    }

}
