<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Script extends Base_Action {

    public function __construct() {
        parent::__construct();

        add_action("elementor/widget/render_content", [$this, 'render_content'], 10, 2);
        //add_action( 'elementor-pro/forms/pre_render', [$this, 'pre_render'], 10, 2); // $settings, $widget );
        add_action('elementor_pro/forms/new_record', [$this, 'new_record'], 999, 2); // $record, $ajax_handler );
        add_filter('e_addons/forms/filter/results', [$this, 'filter_results'], 10, 3);
        
    }

    public function get_description() {
        return esc_html__('Add Script Action to Elementor PRO Form', 'e-addons');
    }

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'script';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Custom JS JavaScript', 'e_addons');
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-custom-js-script';
    }

    public function get_pid() {
        return 10901;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_custom_js', [
            'label' => esc_html__('Custom JS', 'e-addons'),
            'type' => Controls_Manager::CODE,
            //'language' => 'PHP',
            'default' => "<script>" . PHP_EOL . "console.log('Form sent');" . PHP_EOL . "alert('Hi [field id=\"name\"]');" . PHP_EOL . "</script>",
            'description' => esc_html__('<b>WARNING:</b> a dirty code can break the page visualization or other script execution. The script tags are optional, they will be stripped.', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_script_success', [
            'label' => esc_html__('Execute on Success', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'frontend_available' => true,
            'description' => esc_html__('Execute script only on Success. Do not enable it to execute script on all form submission, also on Error result', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {
        $fields = Form::get_form_data($record, false);
        $settings = $this->get_settings(true, $fields);
        
        /*if (!$ajax_handler->is_success && empty($settings['e_form_script_success'])) {
            if (empty($ajax_handler->messages['error'][$this->get_name()])) {
                $extra = '<div class="elementor-hidden elementor-form-custom-js-processed elementor-element-' . $form_id . '">' . $this->strip_tags($settings['e_form_custom_js']) . '</div>';
                $ajax_handler->messages['error'][$this->get_name()] = $extra;
                //$ajax_handler->add_error($this->get_name(), $extra);
            }
        }*/
    }

    public function strip_tags($code = '') {
        $code = str_replace('<script>', '', $code);
        $code = str_replace('</script>', '', $code);
        
        $tmp = explode('<script ', $code);
        if (count($tmp) > 1) {
            foreach($tmp as $key => $val) {
                if ($key) {
                    list($middle, $next) = explode('>', $val, 2);
                    $code .= $next;
                } else {
                    $code = $val;
                }
            }
        }
        
        return $code;
    }

    public function render_content($content, $widget) {
        if ($widget->get_name() == 'form') {
            $settings = $widget->get_settings();
            if (in_array($this->get_name(), $settings['submit_actions'])) {
                //$content = $content . '<div class="elementor-hidden elementor-form-custom-js elementor-element-' . $widget->get_id() . '">'.$settings['e_form_custom_js'].'</div>';
                wp_enqueue_script('e-addons-form-custom-js');
            }
        }
        return $content;
    }

    public function new_record($record, $ajax_handler) {
        $fields = Form::get_form_data($record, false);
        $settings = $this->get_settings(true, $fields);
        $form_id = Form::get_form_id();
        
        if (method_exists($ajax_handler, 'is_condition_satisfy')) {
            if (!$ajax_handler->is_condition_satisfy($this->get_name(), $settings, $fields)) {
                return;
            }
        }

        if (in_array($this->get_name(), $settings['submit_actions'])) {
            $extra = '<div class="elementor-hidden elementor-form-custom-js-processed elementor-element-' . $form_id . '">' . $this->strip_tags($settings['e_form_custom_js']) . '</div>';
            if ($ajax_handler->is_success) {
                wp_send_json_success([
                    'message' => $ajax_handler->get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SUCCESS, $settings) . $extra,
                    'data' => $ajax_handler->data,
                ]);
                die();
            }
            if (empty($settings['e_form_script_success'])) {
                $ajax_handler->messages['error'][$this->get_name()] = $extra;
                //$ajax_handler->add_error($this->get_name(), $extra);
            }
        }
    }
    
    public function filter_results($content, $record, $ajax_handler) {
        $fields = Form::get_form_data($record, false);
        $settings = $this->get_settings(true, $fields);
        $form_id = Form::get_form_id();

        if (in_array($this->get_name(), $settings['submit_actions'])) {
            $extra = '<div class="elementor-hidden elementor-form-custom-js-processed elementor-element-' . $form_id . '">' . $this->strip_tags($settings['e_form_custom_js']) . '</div>';
            if ($ajax_handler->is_success) {
                return $content.$extra;
            }
            if (empty($settings['e_form_script_success'])) {
                $ajax_handler->messages['error'][$this->get_name()] = $extra;
                //$ajax_handler->add_error($this->get_name(), $extra);
            }
        }
        
        return $content;
    }
    
}
