<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class User extends Base_Action {

    public $user = [];
    public static $login_link = false;

    const LOGIN_LINK_SHORTCODE = '[e_user_email_login]';

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'user';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-save-users';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Register User', 'e-addons');
    }

    public function get_pid() {
        return 10819;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_save_user_override', [
            'label' => esc_html__('Register or Update profile', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'add' => [
                    'title' => esc_html__('Register', 'e-addons'),
                    'icon' => 'eicon-plus',
                ],
                'update' => [
                    'title' => esc_html__('Update', 'e-addons'),
                    'icon' => 'eicon-sync',
                ],
                'auto' => [
                    'title' => esc_html__('Auto', 'elementor'),
                    'icon' => 'eicon-plus-circle-o',
                ],
            ],
            'default' => 'add',
            'toggle' => false,
            'description' => esc_html__('Updated User Profile or Register a new one', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_type_user_user', [
            'label' => esc_html__('Search User to update', 'e-addons'),
            'type' => 'e-query',
            'placeholder' => esc_html__('Select a User', 'e-addons'),
            'label_block' => true,
            'query_type' => 'users',
            'description' => esc_html__('Search an User or leave empty for Current Logged In User.', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => 'update',
            ],
                ]
        );

        $widget->add_control(
                'e_form_save_user_data_heading', [
            'label' => esc_html__('Base Data', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);
        $widget->add_control(
                'e_form_save_type_user_username', [
            'label' => esc_html__('UserName', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Use field Shortcode for UserName', 'e-addons') . '<br>' . esc_html__(' or leave empty for rand value', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => 'add',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_email', [
            'label' => esc_html__('User Email', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="email"]',
            'description' => esc_html__('Use field Shortcode for Email, or leave empty for no change in User update', 'e-addons'),
            /* 'condition' => [
              'e_form_save_user_override' => 'add',
              ], */
            'label_block' => 'true',
                ]
        );

        $widget->add_control(
                'e_form_save_pass_user_heading', [
            'label' => esc_html__('Password', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);
        $widget->add_control(
                'e_form_save_type_user_pass', [
            'label' => esc_html__('User Password', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            //'default' => '[field id="user_pass"]',
            'description' => esc_html__('Use field Shortcode (like [field id="pwd"]) for Password, leave empty for a Random password in User creation or no change in User update', 'e-addons'),
            'label_block' => 'true',
                /* 'condition' => [
                  'e_form_save_user_override' => 'add',
                  ], */
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_pass_confirmation', [
            'label' => esc_html__('User Password Confirmation', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Use field Shortcode for Password Confirmation or leave empty to use single password', 'e-addons'),
            'condition' => [
                //'e_form_save_user_override' => 'add',
                'e_form_save_type_user_pass!' => '',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_pass_old', [
            'label' => esc_html__('User Old Password', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Use field Shortcode for Old Password or leave empty to not perform the Old password verification', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => 'update',
                'e_form_save_type_user_pass!' => '',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_pass_confirmation_error', [
            'label' => esc_html__('User Password Mismatch Error', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Passwords do not match', 'e-addons'),
            'condition' => [
                //'e_form_save_user_override' => 'add',
                'e_form_save_type_user_pass!' => '',
                'e_form_save_type_user_pass_confirmation!' => '',
            ],
            'label_block' => 'true',
                ]
        );

        $widget->add_control(
                'e_form_save_role_user_heading', [
            'label' => esc_html__('Role', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);
        $widget->add_control(
                'e_form_save_type_user_role_mode', [
            'label' => esc_html__('Change Role', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'ignore' => esc_html__('Ignore', 'e-addons'),
                'add' => esc_html__('Add', 'e-addons'),
                'set' => esc_html__('Set', 'e-addons'),
            ],
            'default' => 'add',
            'toggle' => false,
            'description' => esc_html__('Set a unique role or Add to existent user roles', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => 'update',
            ],
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_role', [
            'label' => esc_html__('User Role', 'e-addons'),
            'type' => 'e-query',
            //'type' => Controls_Manager::SELECT2,
            //'options' => array('' => esc_html__('Default', 'elementor')) + Utils::get_user_roles(),
            //'default' => 'subscriber'
            'placeholder' => esc_html__('Select Role', 'e-addons'),
            'query_type' => 'users',
            'object_type' => 'role',
            'conditions' => [
                'relation' => 'or',
                'terms' => [
                    [
                        'name' => 'e_form_save_user_override',
                        'operator' => 'in',
                        'value' => ['add', 'auto'],
                    ],
                    [
                        'relation' => 'and',
                        'terms' => [
                            [
                                'name' => 'e_form_save_user_override',
                                'value' => 'update'
                            ],
                            [
                                'name' => 'e_form_save_type_user_role_mode',
                                'operator' => '!==',
                                'value' => 'ignore'
                            ]
                        ]
                    ]
                ]
            ],
            'label_block' => 'true',
            'description' => esc_html__('Select a specific Role or leave empty for defaul one globally set from Wordpres Settings', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_extra_user_heading', [
            'label' => esc_html__('Extra Data', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);
        $widget->add_control(
                'e_form_save_user_fields', [
            'label' => esc_html__('Save Form Fields as User Custom Meta Fields', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
            'description' => esc_html__('Save Form Fields as User Fields or Meta', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => ['update', 'auto'],
            ],
                ]
        );

        $conditions = [
            'relation' => 'or',
            'terms' => [
                [
                    'name' => 'e_form_save_user_override',
                    'value' => 'add',
                ],
                [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'e_form_save_user_override',
                            'operator' => 'in',
                            'value' => ['update', 'auto'],
                        ],
                        [
                            'name' => 'e_form_save_user_fields',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ]
            ]
        ];

        $widget->add_control(
                'e_form_save_user_extra', [
            'label' => esc_html__('Save Technical data', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Add extra User info, like IP, referrer and current ID', 'e-addons'),
            'conditions' => $conditions,
                ]
        );
        $widget->add_control(
                'e_form_save_user_file', [
            'label' => esc_html__('Save Uploaded Files in Media Library', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Generate new attachment in Media Library for each submitted Files', 'e-addons'),
            'conditions' => $conditions,
                ]
        );
        $widget->add_control(
                'e_form_save_user_array', [
            'label' => esc_html__('Store Multiple as Array', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Save submitted fields with multiple values as Array instead default string values separated by comma', 'e-addons'),
            'conditions' => $conditions,
                ]
        );

        $widget->add_control(
                'e_form_save_user_redirect', [
            'label' => esc_html__('Redirect to Author Archive', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Redirect to Author Archive page related to saved User', 'e-addons'),
            'separator' => 'before',
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_login', [
            'label' => esc_html__('Instant Login', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Set WP Auth cookies and automatically this user will be logged in', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => 'add',
            ],
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_link', [
            'label' => esc_html__('Quick Login via Email', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Enable the Email Login Link shortcode ' . self::LOGIN_LINK_SHORTCODE . ' on Email action to provide a direct login link without password', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => 'auto',
            ],
                ]
        );
        /*
          $widget->add_control(
          'e_form_save_type_user_link_single', [
          'label' => esc_html__('Login Link Single Use', 'e-addons'),
          'type' => Controls_Manager::SWITCHER,
          'description' => esc_html__('This link will expire after first use', 'e-addons'),
          'condition' => [
          'e_form_save_user_override' => 'auto',
          'e_form_save_type_user_link!' => '',
          ],
          ]
          );
          $widget->add_control(
          'e_form_save_type_user_link_to', [
          'label' => esc_html__('Login Link Redirect To', 'e-addons'),
          'type' => Controls_Manager::URL,
          'description' => esc_html__('Redirect User to specific page after login', 'e-addons'),
          'condition' => [
          'e_form_save_user_override' => 'auto',
          'e_form_save_type_user_link!' => '',
          ],
          ]
          ); */

        $widget->add_control(
                'e_form_save_type_user_error', [
            'label' => esc_html__('Custom Error Message', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => \ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message('subscriber_already_exists', []),
            'label_block' => true,
            'separator' => 'before',
            'condition' => [
                'e_form_save_user_override!' => 'auto',
            ],
                ]
        );
        $widget->add_control(
                'e_form_save_type_user_error_stop', [
            'label' => esc_html__('Stop Actions on Error', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Stop next actions execution on Error, maybe Username or Email are not valid', 'e-addons'),
            'condition' => [
                'e_form_save_user_override' => 'add',
            ],
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $post_id = absint($_POST['post_id']);
        $queried_id = absint($_POST['queried_id']);
        $form_id = sanitize_key($_POST['form_id']);
        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);
        $settings_raw = $this->get_settings(false);

        if (!empty($settings['e_form_save_user_extra'])) {
            $fields = Form::get_form_data($record, false, true, $settings);
        }

        $user_id = false;

        //var_dump($fields); die();
        $all_fields = $fields;
        $fields = $this->fields_filter($fields);

        $settings['e_form_save_type_user_username'] = $settings['e_form_save_type_user_username']; //sanitize_title();
        if (!$settings['e_form_save_type_user_username']) {
            /* if ($settings['e_form_save_type_user_email']) {
              $settings['e_form_save_type_user_username'] = $settings['e_form_save_type_user_email'];
              } else { */
            $settings['e_form_save_type_user_username'] = 'user_' . time();
            //}
        }
        if ($settings['e_form_save_type_user_pass']) {
            if ($settings_raw['e_form_save_type_user_pass_confirmation']) {
                if ($settings['e_form_save_type_user_pass'] != $settings['e_form_save_type_user_pass_confirmation']) {
                    // not same password
                    $error_msg = $settings['e_form_save_type_user_pass_confirmation_error'];
                    $ajax_handler->add_error_message($error_msg);
                    $ajax_handler->send();
                    die();
                    return false;
                }
            }
        }

        $user_email = get_user_by('email', $settings['e_form_save_type_user_email']);

        $fields = $this->set_wp_obj_fields($fields);

        $user_id = get_current_user_id();
        if (!empty($settings['e_form_save_type_user_user'])) {
            $user_id = $this->get_wp_obj_id($settings['e_form_save_type_user_user'], 'user', $ajax_handler);
        }

        if ($settings['e_form_save_user_override'] == 'update') {
            if (!$user_id) {
                return false;
            }
            $user = get_user_by('ID', $user_id);
            if (!$user) {
                return false;
            }
        }

        switch ($settings['e_form_save_user_override']) {
            case 'add':
                // REGISTER            
                $user_login = get_user_by('login', $settings['e_form_save_type_user_username']);
                if ($user_email || $user_login) {
                    return $this->error($ajax_handler, $settings);
                }
                $this->user['user_email'] = $settings['e_form_save_type_user_email'];
                $this->user['user_pass'] = $settings['e_form_save_type_user_pass'] ? $settings['e_form_save_type_user_pass'] : wp_generate_password();
                if ($settings['e_form_save_type_user_role']) {
                    $this->user['role'] = $settings['e_form_save_type_user_role'];
                }
                $this->user['user_login'] = $settings['e_form_save_type_user_username'];
                $user_id = wp_insert_user($this->user);
                break;
            case 'auto':
                // REGISTER            
                if ($user_email) {
                    $user_id = $user_email->ID;
                } else {
                    $this->user['user_email'] = $settings['e_form_save_type_user_email'];
                    $this->user['user_pass'] = $settings['e_form_save_type_user_pass'] ? $settings['e_form_save_type_user_pass'] : wp_generate_password();
                    if ($settings['e_form_save_type_user_role']) {
                        $this->user['role'] = $settings['e_form_save_type_user_role'];
                    }
                    $this->user['user_login'] = $settings['e_form_save_type_user_email'];
                    $user_id = wp_insert_user($this->user);
                }
            case 'update':
                // UPDATE            
                // cannot use same email on multiple users
                if ($user_email && $user_email->ID != $user_id && $settings['e_form_save_user_override'] != 'auto') {
                    return $this->error($ajax_handler, $settings);
                }

                // UPDATE FIELDS
                $this->user['ID'] = $user_id;
                if ($settings['e_form_save_user_fields']) {
                    $user_id = wp_update_user($this->user);
                }
                $user = get_user_by('ID', $user_id);

                // UPDATE ROLE
                if (!empty($settings['e_form_save_type_user_role']) && $settings['e_form_save_type_user_role_mode'] != 'ignore') {
                    $role_mode = $settings['e_form_save_type_user_role_mode'] . '_role';
                    $user->{$role_mode}($settings['e_form_save_type_user_role']); // refresh or add role
                }

                // UPDATE EMAIL
                if (!empty($settings['e_form_save_type_user_email'])) {
                    $this->user['user_email'] = $settings['e_form_save_type_user_email'];
                    $user_id = wp_update_user(
                            array(
                                'ID' => $user_id,
                                'user_email' => $this->user['user_email'],
                            )
                    );
                }

                // UPDATE PASSWORD
                if ($settings['e_form_save_type_user_pass']) {

                    if ($settings_raw['e_form_save_type_user_pass_old']) {
                        if (!wp_check_password($settings['e_form_save_type_user_pass_old'], $user->user_pass, $user_id)) {
                            // not old password
                            $error_msg = $settings['e_form_save_type_user_pass_confirmation_error'];
                            $ajax_handler->add_error_message($error_msg);
                            $ajax_handler->send();
                            die();
                            return false;
                        }
                    }

                    $this->user['user_pass'] = $settings['e_form_save_type_user_pass'];
                    if ($user_id && !empty($this->user['user_pass'])) {
                        wp_set_password($this->user['user_pass'], $user_id);
                    }
                }
                break;
        }

        if (is_wp_error($user_id) || !$user_id) {
            $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
        }

        // SAVE USER META
        if ($settings['e_form_save_user_override'] == 'add' || ($settings['e_form_save_user_override'] == 'update' && $settings['e_form_save_user_fields'])) {
            //var_dump($fields); die();
            $meta_fields = [];
            foreach ($fields as $key => $value) {
                // not store password
                if (strpos($settings_raw['e_form_save_type_user_pass'], '[field id="' . $key . '"]') === false) {
                    if (strpos($settings_raw['e_form_save_type_user_pass_confirmation'], '[field id="' . $key . '"]') === false) {
                        $meta_fields[$key] = $value;
                    }
                }
            }
            Form::save_extra($user_id, 'user', $settings, $meta_fields);
            if ($settings['e_form_save_user_fields']) {
                $empty_fields = array_diff_key($all_fields, $fields);
                foreach ($empty_fields as $key => $value) {
                    if ($value == '') {
                        if (Utils::is_meta($key, 'user')) {
                            delete_user_meta($user_id, $key);
                        }
                    }
                }
            }
        }

        /**
         * Fires immediately after a new user is registered.
         *
         * @since 1.5.0
         * @since 5.8.0 The `$userdata` parameter was added.
         *
         * @param int   $user_id  User ID.
         * @param array $userdata The raw array of data passed to wp_insert_user().
         * @param []    $fields   Submitted Form Fields.
         */
        $userdata = get_user_by('ID', $user_id);
        do_action('e_addons/forms/register_user', $user_id, $userdata, $fields);

        if (!get_current_user_id()) {
            if (!empty($settings['e_form_save_type_user_login'])) {
                global $user;
                $user = wp_signon(array('user_login' => $this->user['user_email'], 'user_password' => $this->user['user_pass']));
                //wp_signon(array('user_login' => $this->user['user_login'], 'user_password' => $this->user['user_pass']));
            }
        }

        if (!empty($settings['e_form_save_user_redirect'])) {
            $redirect_to = Utils::get_permalink($user_id, 'user');
            if (!empty($redirect_to) && filter_var($redirect_to, FILTER_VALIDATE_URL)) {
                $ajax_handler->add_response_data('redirect_url', $redirect_to);
            }
        }

        if (!empty($settings['e_form_save_type_user_link'])) {
            self::$login_link = $user_id;
            add_filter('wp_mail', function ($atts) {
                //var_dump(self::$attachment); die();
                if (self::$login_link) {
                    $user_id = self::$login_link;
                    $user = get_user_by('ID', $user_id);
                    $key = get_password_reset_key($user);
                    $magic_link = home_url('?e_act=login&email=' . $user->user_email . '&key=' . $key);
                    $atts['message'] = str_replace(self::LOGIN_LINK_SHORTCODE, $magic_link, $atts['message']);
                    //var_dump($atts['message']); die();
                }
                return $atts;
            });
        }
    }

    public function error($ajax_handler, $settings) {
        $error_msg = $settings['e_form_save_type_user_error'] ? $settings['e_form_save_type_user_error'] : \ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message('subscriber_already_exists', $settings);
        $ajax_handler->add_error_message($error_msg);
        if ($settings['e_form_save_type_user_error_stop']) {
            $ajax_handler->send();
            die();
        }
        return false;
    }

}
