<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Option extends Base_Action {

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'option';
    }
    
    public function get_icon() {
        return 'eadd-el-form-pro-act-save-options';
    }
    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Site Option', 'e-addons');
    }

    public function get_pid() {
        return 10890;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_save_option_override', [
            'type' => Controls_Manager::HIDDEN,
            'default' => 'update',
                ]
        );
        
        $widget->add_control(
                'e_form_save_option_fields', [
            'label' => esc_html__('Form Fields', 'e-addons'),
            'type' => 'form_fields',
            'description' => esc_html__('Leave empty or "No field" to save ALL fields as Site Option', 'e-addons'),
            'multiple' => true,
            'label_block' => 'true',
                ]
        );
        
        $widget->add_control(
                'e_form_save_option_file', [
            'label' => esc_html__('Save Files as Media', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Create a Media and save his ID instead the URL', 'e-addons'),
                ]
        );
        $widget->add_control(
                'e_form_save_option_array', [
            'label' => esc_html__('Save Multiple as Array', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Save Files, Select and Checkboxes submitted value as Array instead a comma separated values string', 'e-addons'),
                ]
        );
        
        $widget->add_control(
                'options_page',
                [
                    'label' => esc_html__('<b>Options</b>', 'elementor'),
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => esc_html__('Add or Update site Options:', 'elementor').'<br><a target="_blank" href="'.admin_url('options.php').'">'.esc_html__('See all Options', 'elementor').'</a>',
                    'separator' => 'before',
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $post_id = absint($_POST['post_id']);
        $queried_id = absint($_POST['queried_id']);
        $form_id = sanitize_key($_POST['form_id']);
        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);
        
        $fields = $this->fields_filter($fields);
        
        if (!empty($fields) && is_array($fields)) {
            if (!empty($settings['e_form_save_option_fields']) && is_array($settings['e_form_save_option_fields'])) {
                $settings['e_form_save_option_fields'] = array_filter($settings['e_form_save_option_fields']); // remove the "No field" empty value
            }
            if (!empty($settings['e_form_save_option_fields'])) {
                foreach ($fields as $akey => $adata) {
                    if (!in_array($akey, $settings['e_form_save_option_fields'])) {
                        unset($fields[$akey]);
                    }
                }
            }
        }
        
        if (!empty($fields)) {
            Form::save_extra(-1, 'option', $settings, $fields);
        }

    }

}
