<!--<h3><?php esc_html_e( 'Settings', 'mainwp-backupwordpress-extension' ); ?></h3>-->

<?php $mainwp_hmbkp_form_errors = mainwp_hmbkp_get_settings_errors(); ?>

<?php if ( ! empty( $mainwp_hmbkp_form_errors ) ) { ?>

	<div id="hmbkp-warning" class="error settings-error">

		<?php foreach ( $mainwp_hmbkp_form_errors as $error ) { ?>
			<p><strong><?php echo esc_html( $error ); ?></strong></p>
		<?php } ?>

	</div>

	<?php
}

// We can clear them now we've displayed them
mainwp_hmbkp_clear_settings_errors();
?>

<form method="post" class="ui form" action="<?php echo admin_url( 'admin-post.php' ); ?>">

	<input type="hidden" name="mainwp_hmbkp_schedule_id" value="<?php echo esc_attr( $schedule->get_id() ); ?>" />
	<input type="hidden" name="mainwp_backupwp_site_id" value="<?php echo $current_site_id; ?>" />
	<input type="hidden" name="action" value="mainwp_hmbkp_edit_schedule_submit" />

	<?php wp_nonce_field( 'mainwp-hmbkp-edit-schedule', 'mainwp-hmbkp-edit-schedule-nonce' ); ?>

	<div class="ui grid field">
		<label class="six wide column middle aligned"><?php _e( 'Backup', 'mainwp-backupwordpress-extension' ); ?></label>
	  <div class="ten wide column">
			<select name="mainwp_hmbkp_schedule_type" id="mainwp_hmbkp_schedule_type" class="ui dropdown">
				<option<?php selected( $schedule->get_type(), 'complete' ); ?> value="complete"><?php _e( 'Both Database &amp; files', 'mainwp-backupwordpress-extension' ); ?></option>
				<option<?php selected( $schedule->get_type(), 'file' ); ?> value="file"><?php _e( 'Files only', 'mainwp-backupwordpress-extension' ); ?></option>
				<option<?php selected( $schedule->get_type(), 'database' ); ?> value="database"><?php _e( 'Database only', 'mainwp-backupwordpress-extension' ); ?></option>
			</select>
		</div>
	</div>

	<div class="ui grid field">
		<label class="six wide column middle aligned"><?php _e( 'Schedule', 'mainwp-backupwordpress-extension' ); ?></label>
	  <div class="ten wide column">
			<select name="mainwp_hmbkp_schedule_recurrence[mainwp_hmbkp_type]" id="mainwp_hmbkp_schedule_recurrence_type" class="ui dropdown">

				<option value="manually"><?php _e( 'Manual Only', 'mainwp-backupwordpress-extension' ); ?></option>

				<?php foreach ( $schedule->get_cron_schedules() as $cron_schedule => $cron_details ) : ?>

					<option <?php selected( $schedule->get_reoccurrence(), $cron_schedule ); ?> value="<?php echo esc_attr( $cron_schedule ); ?>">

						<?php esc_html_e( $cron_details['display'], 'mainwp-backupwordpress-extension' ); ?>

					</option>

				<?php endforeach; ?>

			</select>
		</div>
	</div>

	<?php
	if ( ! $start_time = $schedule->get_schedule_start_time( false ) ) {
		$start_time = time();
	}
	?>

	<?php $start_date_array = date_parse( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $start_time ) ); ?>

	<div class="ui grid field recurring-setting" id="start-day">
		<label class="six wide column middle aligned"><?php _e( 'Start Day', 'mainwp-backupwordpress-extension' ); ?></label>
	  <div class="ten wide column">
			<select id="mainwp_hmbkp_schedule_start_day_of_week" name="mainwp_hmbkp_schedule_recurrence[mainwp_hmbkp_schedule_start_day_of_week]" class="ui dropdown">

				<?php
				$weekdays = array(
					'monday' => __( 'Monday' ),
					'tuesday' => __( 'Tuesday' ),
					'wednesday' => __( 'Wednesday' ),
					'thursday' => __( 'Thursday' ),
					'friday' => __( 'Friday' ),
					'saturday' => __( 'Saturday' ),
					'sunday' => __( 'Sunday' ),
				);

				foreach ( $weekdays as $key => $day ) :
					?>

					<option value="<?php echo esc_attr( $key ) ?>" <?php selected( strtolower( date_i18n( 'l', $start_time ) ), $key ); ?>><?php echo esc_html( $day ); ?></option>

				<?php endforeach; ?>

			</select>
		</div>
	</div>

	<div class="ui grid field recurring-setting" id="start-date">
		<label class="six wide column middle aligned"><?php _e( 'Start Day', 'mainwp-backupwordpress-extension' ); ?></label>
		<div class="ten wide column">
			<input type="number" min="0" max="31" step="1" id="mainwp_hmbkp_schedule_start_day_of_month" name="mainwp_hmbkp_schedule_recurrence[mainwp_hmbkp_schedule_start_day_of_month]" value="<?php echo esc_attr( $start_date_array['day'] ); ?>">
		</td>
		</div>
	</div>

	<div class="ui grid field recurring-setting" id="schedule-start">
		<label class="six wide column middle aligned"><?php _e( 'Start Time', 'mainwp-backupwordpress-extension' ); ?></label>
		<div class="ten wide column">
			<span class="field-group">

				<label for="mainwp_hmbkp_schedule_start_hours"><input type="number" min="0" max="23" step="1" name="mainwp_hmbkp_schedule_recurrence[mainwp_hmbkp_schedule_start_hours]" id="mainwp_hmbkp_schedule_start_hours" value="<?php echo esc_attr( $start_date_array['hour'] ); ?>">

					<?php _e( 'Hours', 'mainwp-backupwordpress-extension' ); ?></label>

				<label for="mainwp_hmbkp_schedule_start_minutes"><input type="number" min="0" max="59" step="1" name="mainwp_hmbkp_schedule_recurrence[mainwp_hmbkp_schedule_start_minutes]" id="mainwp_hmbkp_schedule_start_minutes" value="<?php echo esc_attr( $start_date_array['minute'] ); ?>">

					<?php _e( 'Minutes', 'mainwp-backupwordpress-extension' ); ?></label>

			</span>
			<p class="descriprion"><strong><?php esc_html_e( 'Please use 24 hour format for hours', 'mainwp-backupwordpress-extension' ); ?></strong></p>
			<p class="twice-js description<?php if ( $schedule->get_reoccurrence() !== 'hmbkp_fortnightly' ) { ?> hidden<?php } ?>"><?php _e( 'The second backup will run 12 hours after the first', 'mainwp-backupwordpress-extension' ); ?></p>
		</td>
		</div>
	</div>

	<div class="ui grid field">
		<label class="six wide column middle aligned"><?php _e( 'Number of backups to store on this server', 'mainwp-backupwordpress-extension' ); ?></label>
		<div class="ten wide column">
			<input type="number" id="mainwp_hmbkp_schedule_max_backups" name="mainwp_hmbkp_schedule_max_backups" min="1" step="1" value="<?php echo esc_attr( $schedule->get_max_backups() ); ?>" />
		</td>
		</div>
	</div>




	<?php
	foreach ( MAINWP\BackUpWordPress\Services::get_services( $schedule ) as $service ) {
		$service->field();
	}
	?>


	<div class="ui clearing divider"></div>


		<button type="submit" class="ui big green right floated button"><?php _e( 'Done', 'mainwp-backupwordpress-extension' ); ?></button>

	<div class="ui hidden clearing divider"></div>


</form>
