<?php

/**
 * =======================================
 * MainWP Database Updater Overview
 * =======================================
 */
namespace MainWP\Extensions\DatabaseUpdater;

class MainWP_Database_Updater_Overview {


    // Singleton
    private static $instance = null;

    /**
     * Get Instance
     *
     * Creates public static instance.
     *
     * @static
     *
     * @return MainWP_Database_Updater_Overview
     */
    static function get_instance() {
        if ( null == self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }


    /**
     * constructor.
     *
     * Run each time the class is called.
     */
    public function __construct() {
        add_action( 'admin_init', array( &$this, 'admin_init' ) );
    }

    /**
     * Method admin_init() initiated by init()
     *
     * Instantiate Hooks for the page.
     */
    public function admin_init() {
        do_action( 'mainwp_ajax_add_action', 'mainwp_database_updater_update_db', array( &$this, 'ajax_update_db' ) );
    }

    /**
     * Render Tabs.
     *
     * Renders the page tabs.
     */
    public function gen_tabs_general( $website = false ) {
        ?>
            <div id="mainwp-database-updater-log-tab">
            <?php MainWP_Database_Updater_Updates_Plugins::get_instance()->render_db_updates( $website ); ?>
                <div class="ui clearing hidden divider"></div>
            </div>
        <?php
    }

    /**
     * Ajax upgrade plugin.
     */
    public function ajax_update_db() {
        do_action( 'mainwp_secure_request', 'mainwp_database_updater_update_db' );

        $site_id = isset( $_POST['websiteId'] ) ? intval( $_POST['websiteId'] ) : 0;
        $slugs   = isset( $_POST['slugs'] ) ? wp_unslash( $_POST['slugs'] ) : '';
        $type    = isset( $_POST['type'] ) ? sanitize_text_field( wp_unslash( $_POST['type'] ) ) : '';

        if ( empty( $site_id ) || empty( $slugs ) ) {
            wp_send_json( array( 'error' => esc_html__( 'Error: empty Site ID or empty Plugin Slugs.', 'mainwp-database-updater-extension' ) ) );
        }

        global $mainWPDatabaseUpdaterExtensionActivator;

        $post_data = array(
            'mwp_action' => 'update_db',
            'list'       => urldecode( implode( ',', $slugs ) ),
            'type'       => $type,
        );

        $information = apply_filters( 'mainwp_fetchurlauthed', $mainWPDatabaseUpdaterExtensionActivator->get_child_file(), $mainWPDatabaseUpdaterExtensionActivator->get_child_key(), $site_id, 'db_updater', $post_data );

        $response = array();

        if ( is_array( $information ) && isset( $information['errorCode'] ) ) {
            $response['errorCode'] = esc_html( $information['errorCode'] );
        }

        if ( is_array( $information ) && isset( $information['error'] ) ) {
            $response['error'] = esc_html( $information['error'] );
        } elseif ( is_array( $information ) && isset( $information['upgrades'] ) ) {
            if ( isset( $information['plugin_db_upgrades'] ) ) {
                MainWP_Database_Updater_Utility::update_website_option( $site_id, 'plugin_db_upgrades', ( is_array( $information['plugin_db_upgrades'] ) ? wp_json_encode( $information['plugin_db_upgrades'] ) : '' ) );
            }
            $tmp = array();
            if ( isset( $information['upgrades'] ) ) {
                foreach ( $information['upgrades'] as $k => $v ) {
                    $tmp[ rawurlencode( $k ) ] = $v;
                }
            }
            $response['result'] = $tmp;
        } else {
            $response['error'] = esc_html__( 'Undefined error occurred. Please try again.', 'mainwp-database-updater-extension' );
        }
        wp_send_json( $response );
    }
}
