jQuery(document).ready(function ($) {

    // Filter groups
    $('#sucuri_btn_display').on('click', function () {
        $(this).closest('form').submit();
    });

    // Initiate Scan (Site Securty Scan page)
    $('#mainwp-sucuri-run-scan').on('click', function () {
        mainwp_sucuri_run_scan(this, false);
        return false;
    });

    // Initiate Scan (Site Securty Scan page)
    $('#mainwp-sucuri-delete-all-reports').on('click', function () {
        mainwp_sucuri_delete_all_reports(this);
        return false;
    });


    $('#mainwp_sucuri_groups_select').dropdown({
        onChange: function (group_id, text, $choice) {
            let url = 'admin.php?page=Extensions-Mainwp-Sucuri-Extension';
            if (group_id > 0)
                url += '&group_id=' + group_id;
            location.href = url;
        }
    });

    // Scan site (Site Securty Scan page)
    let mainwp_sucuri_run_scan = function (pObj, retring) {

        let data = {
            action: 'mainwp_sucuri_security_scan',
            siteId: $('input[name="mainwp_sucuri_site_id"]').val(),
            wp_nonce: $('input[name="mainwp_sucuri_scan_nonce"]').val()
        }

        $('#mainwp-sucuri-run-scan').attr('disabled', 'disabled');

        $('#mainwp-sucuri-scan-modal').modal({
            closable: false,
            onHide: function () {
                location.reload();
            }
        }).modal('show');

        let statusEl = $('.ui.dimmer');

        statusEl.addClass('active');

        if (retring) {
            statusEl.html(__("Connection error detected. The Verify Certificate option has been switched to NO. Retrying in progress.")).show();
        }

        statusEl.find('.text').html(__("Scanning the child site. Please wait..."));

        jQuery.post(ajaxurl, data, function (response) {
            if (response.result == 'retry_action') {
                jQuery("#mainwp_sucuri_verify_certificate").val(0);
                mainwp_sucuri_run_scan(pObj, true);
            } else {
                statusEl.removeClass('active');
                $('#mainwp-sucuri-run-scan').removeAttr('disabled');
                $('#mainwp-sucuri-security-scan-result').html(response.result);
                $('#mainwp-sucuri-scan-list').prepend(response.item);
            }
        }, 'json');
    }

    let mainwp_sucuri_delete_all_reports = function (e) {
        let data = mainwp_secure_data({
            action: 'mainwp_sucuri_delete_all_reports',
            site_id: $('input[name="mainwp_sucuri_site_id"]').val(),
            wp_nonce: $('input[name="mainwp_sucuri_delete_all_reports_nonce"]').val()
        });

        $('#mainwp-sucuri-reports').html('<div class="ui segment"><div class="ui active inverted dimmer"><div class="ui medium text loader">Please wait...</div></div><p></p><p></p></div>');

        $.post(ajaxurl, data, function (response) {
            if (response?.success) {
                setTimeout(function () {
                    window.location.href = location.href;
                }, 200);
            } else {
                $('#mainwp-sucuri-reports').html('<div class="ui segment"><div class="ui active inverted dimmer"><div class="ui medium text loader">An unexpected error occurred. Please reload the page and try again.</div></div><p></p><p></p></div>');
                setTimeout(function () {
                    window.location.href = location.href;
                }, 3000);
            }
        }, 'json');
    }

    // Initiate Scan (Sucuri Extension page)
    jQuery(document).on('click', '.mainwp-sucuri-scan-site', function () {
        mainwp_sucuri_scan_site(this, false);
        return false;
    });

    // Scan site (Sucuri Extension page)
    let mainwp_sucuri_scan_site = function (obj, retring) {

        jQuery("#mainwp-sucuri-scan-modal").modal({
            closable: false,
            onHide: function () {
                location.reload();
            }
        }).modal('show');


        let siteId = jQuery(obj).attr('site_id');
        let data = {
            action: 'mainwp_sucuri_scan_site_action',
            siteId: siteId,
            wp_nonce: jQuery('#wp_nonce_scan').val()
        }


        let statusEl = jQuery('.ui.dimmer');

        statusEl.addClass('active');

        if (retring) {
            statusEl.find(".ui.text").html(' ' + __("Connection error detected. The Verify Certificate option has been switched to NO. Retrying..."));
        }

        jQuery.post(ajaxurl, data, function (response) {
            if (response == 'retry_action') {
                jQuery("#mainwp_sucuri_verify_certificate").val(0);
                mainwp_sucuri_scan_site(obj, true);
            } else {
                jQuery('#mainwp-sucuri-scan-modal').find('.content').html('');
                jQuery('#mainwp-sucuri-scan-modal').find('.content').html(response);
            }
        });
    }

    // Show saved repot
    jQuery(document).on('click', '.mainwp-sucuri-saved-report-show', function () {

        jQuery('#mainwp-sucuri-scan-modal').modal('show');
        jQuery('#mainwp-sucuri-scan-modal').find('.content').html('');

        let statusEl = jQuery('.ui.dimmer').find('.text');

        statusEl.html(__('Loading report...'));

        let data = {
            action: 'mainwp_sucuri_show_report',
            reportId: $(this).attr('report-id'),
            siteId: $('input[name="mainwp_sucuri_site_id"]').val(),
            wp_nonce: $('input[name="mainwp_sucuri_show_report_nonce"]').val()
        };

        jQuery.post(ajaxurl, data, function (response) {
            if (!response || response === 'FAIL') {
                statusEl.html(__('Loading Report failed. Please try again.'));
            } else {
                jQuery('#mainwp-sucuri-scan-modal').find('.content').html(response);
            }
        });

        return false;
    });

    // Delete saved report
    $(document).on('click', '.mainwp-sucuri-saved-report-delete', function () {
        let parent = $(this).closest('.item');

        let data = {
            action: 'mainwp_sucuri_delete_report',
            reportId: $(this).attr('report-id'),
            wp_nonce: $('input[name="mainwp_sucuri_delete_report_nonce"]').val()
        }

        $.post(ajaxurl, data, function (response) {
            if (response && response === 'SUCCESS') {
                parent.html('Report deleted successfully.');
                parent.fadeOut(2000);
            } else {
                parent.html('Report could not be deleted.');
                location.reload();
            }
        });
        return false;
    });

    // Set reminder
    $('#mainwp_sucuri_remind_scan').on('change', function (e) {
        let data = {
            action: 'mainwp_sucuri_change_remind',
            siteId: $('input[name="mainwp_sucuri_site_id"]').val(),
            remind: $(this).val(),
            wp_nonce: $('input[name="mainwp_sucuri_change_remind_nonce"]').val()
        }

        let statusEl = $('#mainwp-sucuri-message-zone');
        statusEl.html('');

        $.post(ajaxurl, data, function (response) {
            if (response == 'SUCCESS') {
                statusEl.addClass('green');
                statusEl.html("Reminder saved successfully.").show().fadeOut(2000);
                statusEl.removeClass('green');
            } else {
                statusEl.addClass('red');
                statusEl.html("Reminder could not be saved. Please try again.").show().fadeOut(2000);
                statusEl.removeClass('red');
            }
        });
    });

    // Set SSL Cert verificaion
    $('#mainwp_sucuri_verify_certificate').on('change', function (e) {

        let data = {
            action: 'mainwp_sucuri_sslverify_certificate',
            security_sslverify: $(this).val()
        }

        let statusEl = $('#mainwp-sucuri-message-zone');
        statusEl.html('');

        $.post(ajaxurl, data, function (response) {
            if (response) {
                if (response.saved == '1') {
                    statusEl.addClass('green');
                    statusEl.html("Changes saved successfully.").show().fadeOut(2000);
                    statusEl.removeClass('green');
                } else if (response.error) {
                    statusEl.addClass('red');
                    statusEl.html(response.error).show().fadeOut(2000);
                    statusEl.removeClass('red');
                } else {
                    statusEl.addClass('red');
                    statusEl.html("Saving chagnes failed. Please try again.").show().fadeOut(2000);
                    statusEl.removeClass('red');
                }
            } else {
                statusEl.addClass('red');
                statusEl.html("Saving chagnes failed. Please try again.").show().fadeOut(2000);
                statusEl.removeClass('red');
            }
        }, 'json');
    });
});

let sucuri_bulkTotalThreads = 0;
let sucuri_bulkCurrentThreads = 0;
let sucuri_bulkMaxThreads = 6
let sucuri_bulkFinishedThreads = 0;
let sucuri_bulkSuccessCount = 0;

// Bulk actions menu trigger
jQuery(document).on('click', '#mainwp-sucuri-bulk-actions-button', function () {
    let action = jQuery('#mainwp-sucuri-rerports-actions').val();
    let selector = '#mainwp-sucuri-sites-table tbody tr';

    if ('' !== action) {
        jQuery(selector).each(function () {
            if (jQuery(this).find('td.check-column input[type="checkbox"]:checked').length > 0) {
                jQuery(this).addClass('queue');
            } else {
                jQuery(this).removeClass('queue');
            }
        });

        sucuri_bulkTotalThreads = jQuery(selector + '.queue').length;
        sucuri_bulkFinishedThreads = 0;

        if (sucuri_bulkTotalThreads === 0) {
            return;
        }

        mainwp_confirm(__('Are you sure?'), function () {
            mainwp_sucuri_reports_bulk_action(action, selector);
        }, false, false, true);
    }
});

let mainwp_sucuri_reports_bulk_action = function (act, selector) {
    if ('delete-reports' === act) {
        mainwp_sucuri_delete_reports_start_next(selector);
    }
}

let mainwp_sucuri_delete_reports_start_next = function (selector) {
    let rowProcess;
    while (rowProcess = jQuery(selector + '.queue:first') && rowProcess.length > 0 && sucuri_bulkCurrentThreads < sucuri_bulkMaxThreads) {
        rowProcess.removeClass('queue');
        sucuri_bulkCurrentThreads++;
        mainwp_sucuri_delete_reports_specific(rowProcess, selector);
    }
}

let mainwp_sucuri_delete_reports_specific = function (objRow, selector) {

    let data = mainwp_secure_data({
        action: 'mainwp_sucuri_bulk_delete_reports',
        site_id: objRow.attr('site-id'),
        wp_nonce: jQuery('input[name="mainwp_sucuri_delete_reports_nonce"]').val(),
    });

    objRow.html('<td colspan="99"><i class="notched circle loading icon"></i> Deleting the site Sucuri scan reports. Please wait...</td>');
    jQuery.post(ajaxurl, data, function (response) {
        if (response?.error) {
            objRow.html('<td colspan="99"><i class="red times icon"></i>' + response['error'] + '</td>');
        } else if (response?.no_reports) {
            objRow.html('<td colspan="99"><i class="exclamation icon"></i>' + response['no_reports'] + '</td>');
        } else if (response?.success) {
            objRow.html('<td colspan="99"><i class="green check icon"></i> Sucuri scan reports have been successfully deleted!</td>');
            sucuri_bulkSuccessCount++;
        } else {
            objRow.html('<td colspan="99"><i class="red times icon"></i> An unexpected error occurred. Please reload the page and try again.</td>');
        }
        sucuri_bulkCurrentThreads--;
        sucuri_bulkFinishedThreads++;
        mainwp_sucuri_delete_reports_start_next(selector);
        mainwp_sucuri_bulk_action_done();
    }, 'json');
    return false;
}

let mainwp_sucuri_bulk_action_done = function (reload) {
    if (sucuri_bulkFinishedThreads > 0 && sucuri_bulkFinishedThreads == sucuri_bulkTotalThreads && sucuri_bulkSuccessCount == sucuri_bulkTotalThreads) {
        setTimeout(function () {
            window.location.href = location.href;
        }, 2000);
    }
}
