<?php
/*
  UpdraftPlus Addon: lockadmin:Password-protect the UpdraftPlus Settings Screen
  Description: Provides the ability to lock the UpdraftPlus settings with a password
  Version: 1.1
  Shop: /shop/lockadmin/
  Latest Change: 1.9.43
 */

if ( ! defined( 'MAINWP_UPDRAFT_PLUS_DIR' ) ) {
		die( 'No direct access allowed' ); }

if ( defined( 'UPDRAFTPLUS_NOADMINLOCK' ) && UPDRAFTPLUS_NOADMINLOCK ) {
	return; 
}

$mainwp_updraft_plus_addon_moredatabase = new MainWP_Updraft_Plus_Addon_LockAdmin;

class MainWP_Updraft_Plus_Addon_LockAdmin {

	private $correct_password_supplied = null;
	private $default_support_url = 'https://updraftplus.com/faqs/locked-updraftplus-settings-page-forgotten-password-unlock/';

	public function __construct() {
			add_filter( 'mainwp_updraftplus_settings_page_render', array( $this, 'settings_page_render' ) );
	}

	private function check_user_cookie( $password ) {
		if ( empty( $password ) ) {
				return true; }
			// Value in seconds
			$session_length = $this->opts['session_length'];
		if ( ! $session_length ) {
				$session_length = 86400; }

			// A lock has been set. Has the user passed the test?
		if ( empty( $_COOKIE['updraft_unlockadmin'] ) ) {
				return false; }

			// Cookie in correct format?
		if ( ! preg_match( '/^(\d+):(.*)$/', $_COOKIE['updraft_unlockadmin'], $matches ) ) {
				return false; }

			$cookie_time = $matches[1]; # The time when the session began
			$cookie_hash = $matches[2];

			$time_now = time();

			# Cookie is older than session length
		if ( $time_now > $cookie_time + $session_length ) {
				return false; }

			$cookie_session_began = $cookie_time - ($cookie_time % $session_length);

			$user = wp_get_current_user();
		if ( ! is_a( $user, 'WP_User' ) ) {
				return false; }

			// The cookie relies on the user ID, password and session time. So, someone stealing the cookie can't use it forever. They need the password to generate valid cookies.
			$correct_hash = hash( 'sha256', $user->ID . '-' . $password . '-' . $cookie_session_began );

		if ( $correct_hash != $cookie_hash ) {
				return false; }

			return true;
	}

	private function get_opts() {
			$this->opts = MainWP_Updraft_Plus_Options::get_updraft_option( 'updraft_adminlocking' );
		if ( ! is_array( $this->opts ) ) {
				$this->opts = array(); }
		if ( ! isset( $this->opts['password'] ) ) {
				$this->opts['password'] = ''; }
		if ( ! isset( $this->opts['session_length'] ) ) {
				$this->opts['session_length'] = 3600; }
		if ( ! isset( $this->opts['support_url'] ) ) {
				$this->opts['support_url'] = ''; }
	}

	

	public function settings_page_render( $go ) {
		if ( ! $go ) {
				return $go; }
		if ( $this->correct_password_supplied ) {
				return true; }
			$this->get_opts();
			$password = $this->opts['password'];
		if ( $this->check_user_cookie( $password ) ) {
				return $go; }
			return false;
	}
}
