<?php

class MainWP_Vulnerability_Hooks { // phpcs:ignore -- NOSONAR - multi methods.
	protected static $_instance = null;

	public $loaded_sites_vuln_results = null;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function admin_init() {
		add_action( 'mainwp_added_new_site', array( &$this, 'added_new_site' ), 10, 1 );
		add_action( 'mainwp_delete_site', array( &$this, 'hook_delete_site' ), 10, 1 );
		add_action( 'mainwp_site_synced', array( &$this, 'site_synced' ), 10, 2 );
		add_filter( 'mainwp_vulner_getvulner', array( &$this, 'hook_mainwp_vulner_getvulner' ), 10, 2 );
		add_filter( 'mainwp_sitestable_getcolumns', array( $this, 'hook_sitestable_getcolumns' ), 10 );
		add_filter( 'mainwp_sitestable_item', array( $this, 'hook_sitestable_item' ), 10 );
		add_action( 'mainwp_sitestable_prepared_items', array( $this, 'hook_sitestable_prepared_items' ), 10, 2 );
		add_action( 'mainwp_after_updates_stats', array( $this, 'render_overview_info' ) );
	}


	public function added_new_site( $site_id = null ) {
		if ( empty( $site_id ) ) {
			return;
		}
		$update = array(
			'site_id' => $site_id,
		);
		MainWP_Vulnerability_DB::instance()->update_vulner_result( $update );
	}

	public function hook_delete_site( $website ) {
		if ( $website ) {
			MainWP_Vulnerability_DB::instance()->delete_result_by( 'site_id', $website->id );
		}
	}

	public function hook_sitestable_getcolumns( $columns ) {
		$columns['vulner_checker'] = __( 'Vulnerabilities', 'mainwp-vulnerability-checker-extension' );
		return $columns;
	}

	public function hook_sitestable_item( $item ) {
		$site_id = intval( $item['id'] );

		$result = is_array( $this->loaded_sites_vuln_results ) && isset( $this->loaded_sites_vuln_results[ $site_id ] ) ? $this->loaded_sites_vuln_results[ $site_id ] : array();

		$service = MainWP_Vulnerability_Checker::get_enabled_service();

		if ( 'nvd_nist' === $service ) {
			$result = MainWP_Vulnerability_Nvd_Checker::instance()->recalculate_unignored_counting_numbers( $result );
		}

		$vulner_count = 0;

		if ( $result ) {
			$vulner_count = $result['wp_vulner_count'] + $result['plugin_vulner_count'] + $result['theme_vulner_count'];
		}

		$label_class = 'green ';
		$icon_class  = 'check ';

		if ( $vulner_count > 0 ) {
			$label_class = 'red';
			$icon_class  = 'exclamation triangle ';
		}

		$item['vulner_checker'] = '<a href="admin.php?page=ManageSitesVulnerabilities&id=' . $site_id . '"><span class="ui ' . $label_class . ' label"><i class="' . $icon_class . ' icon"></i>' . $vulner_count . '</span></a>';

		return $item;
	}

	public function hook_sitestable_prepared_items( $websites, $site_ids ) {
		if ( null === $this->loaded_sites_vuln_results ) {
			$this->loaded_sites_vuln_results = array();
			$results = MainWP_Vulnerability_DB::instance()->get_result_by( 'site_ids', $site_ids );
			if ( is_array( $results ) ) {
				foreach ( $results as $result ) {
					$this->loaded_sites_vuln_results[ $result['site_id'] ] = $result;
				}
			}
		}
	}

	public static function get_website_options( $value, $website, $which_opt, $json = true ) {
		$value = apply_filters( 'mainwp_getwebsiteoptions', false, $website, $which_opt ); // NOSONAR
		if ( $json ) {
			if ( ! empty( $value ) ) {
				$value = json_decode( $value, true );
				if ( ! is_array( $value ) ) {
					$value = array();
				}
			} else {
				$value = array();
			}
		}
		return $value;
	}

	/**
	 * Method update_website_option().
	 *
	 * Update the website option.
	 *
	 * @param object|int $website website object or ID.
	 * @param string     $opt_name website.
	 * @param string     $opt_value website.
	 */
	public static function update_website_option( $website, $opt_name, $opt_value ) {
		return apply_filters( 'mainwp_updatewebsiteoptions', false, $website, $opt_name, $opt_value );
	}

	public function hook_vulnerable_get_data( $reports_data, $site_id ) {

		if ( empty( $site_id ) ) {
			return $reports_data;
		}

		$last_check = 0;
		$result     = MainWP_Vulnerability_DB::instance()->get_result_by( 'site_id', $site_id );

		$vulner_result = array();
		if ( $result && ! empty( $result['result'] ) ) {
			$vulner_result = json_decode( $result['result'], true );
			if ( ! is_array( $vulner_result ) ) {
				$vulner_result = array();
			}
			$last_check = $result['last_check'];
		}

		$plug_results = is_array( $vulner_result ) && isset( $vulner_result['plugin'] ) ? $vulner_result['plugin'] : array();
		$th_results   = is_array( $vulner_result ) && isset( $vulner_result['theme'] ) ? $vulner_result['theme'] : array();

		if ( 'nvd_nist' == MainWP_Vulnerability_Checker::get_enabled_service() ) {
			$website     = new stdClass();
			$website->id = $site_id;

			$site_ignored_plugins_issues = self::get_website_options( false, $website, 'ignored_issues_plugins' );
			$site_ignored_themes_issues  = self::get_website_options( false, $website, 'ignored_issues_themes' );

			$global_ignored_plugins_issues = self::get_website_options( false, 0, 'ignored_issues_plugins' ); // 0: for global.
			$global_ignored_themes_issues  = self::get_website_options( false, 0, 'ignored_issues_themes' ); // 0: for global.

			$plug_vuln_content = '';

			foreach ( $plug_results as $plug_slug => $plug_vuln ) :
				if ( empty( $plug_vuln ) ) {
					continue;
				}

				$plug_vuln = json_decode( $plug_vuln, true );

				foreach ( $plug_vuln as $pl_name => $pl_vuln_data ) {
					$plugin_name    = esc_html( $pl_name );
					$pl_vuln_issues = MainWP_Vulnerability_Nvd_Checker::get_vuln_issues( $pl_vuln_data['vulnerabilities'], 'plugin' );

					if ( ! empty( $pl_vuln_issues ) ) {
						if ( is_array( $site_ignored_plugins_issues ) ) {
							$pl_vuln_issues = array_diff_key( $pl_vuln_issues, $site_ignored_plugins_issues );
						}
						if ( is_array( $global_ignored_plugins_issues ) ) {
							$pl_vuln_issues = array_diff_key( $pl_vuln_issues, $global_ignored_plugins_issues );
						}
					}

					if ( ! empty( $pl_vuln_issues ) ) :
						usort(
							$pl_vuln_issues,
							function ( $a, $b ) {
								if ( $a['datetime'] == $b['datetime'] ) {
									return 0;
								}
								return ( $a['datetime'] > $b['datetime'] ) ? -1 : 1;
							}
						);
						foreach ( $pl_vuln_issues as $item ) {
							$plug_vuln_content .= $plugin_name . ': ' . MainWP_Vulnerability_Utility::formatTimestamp( MainWP_Vulnerability_Utility::get_timestamp( $item['datetime'] ) ) . '<br/>';
							$plug_vuln_content .= esc_html( $item['detail'] ) . '<br/>';
						}
					endif;
				}
			endforeach;

			$theme_vuln_content = '';
			foreach ( $th_results as $th_slug => $data ) :
				$th_slug      = esc_html( $th_slug );
				$show_actions = false;
				$theme_vuln   = $data['vulner_data'];
				$theme_vuln   = json_decode( $theme_vuln, true );
				$theme_name   = '';
				if ( empty( $theme_vuln['parent'] ) ) :
					foreach ( $theme_vuln as $th_name => $th_vuln_data ) {
						$theme_name     = esc_html( $th_name );
						$th_vuln_issues = MainWP_Vulnerability_Nvd_Checker::get_vuln_issues( $th_vuln_data['vulnerabilities'] );

						if ( ! empty( $th_vuln_issues ) ) {
							if ( is_array( $site_ignored_themes_issues ) ) {
								$th_vuln_issues = array_diff_key( $th_vuln_issues, $site_ignored_themes_issues );
							}
							if ( is_array( $global_ignored_themes_issues ) ) {
								$th_vuln_issues = array_diff_key( $th_vuln_issues, $global_ignored_themes_issues );
							}
						}

						if ( ! empty( $th_vuln_issues ) ) :
							usort(
								$th_vuln_issues,
								function ( $a, $b ) {
									if ( $a['datetime'] == $b['datetime'] ) {
										return 0;
									}
									return ( $a['datetime'] > $b['datetime'] ) ? -1 : 1;
								}
							);
							foreach ( $th_vuln_issues as $item ) {
								$theme_vuln_content .= $theme_name . ': ' . MainWP_Vulnerability_Utility::formatTimestamp( MainWP_Vulnerability_Utility::get_timestamp( $item['datetime'] ) ) . '<br/>';
								$theme_vuln_content .= esc_html( $item['detail'] ) . '<br/>';
							}
							endif;
					}

				endif;
			endforeach;

			$reports_data['vulnerable.plugins']   = $plug_vuln_content;
			$reports_data['vulnerable.themes']    = $theme_vuln_content;
			$reports_data['vulnerable.checkdate'] = ! empty( $last_check ) ? MainWP_Vulnerability_Utility::formatTimestamp( $last_check ) : 'N/A';
			$result                               = MainWP_Vulnerability_Nvd_Checker::instance()->recalculate_unignored_counting_numbers( $result );
		} else {

			$plug_vuln_content = '';
			foreach ( $plug_results as $plug_slug => $plug_vuln ) :
				if ( ! empty( $plug_vuln ) ) :
					$show_actions = false;
					$plug_vuln    = json_decode( $plug_vuln, true );
					$plugin_name  = '';

					foreach ( $plug_vuln as $pl_name => $pl_vuln_data ) {
						$plugin_name = esc_html( $pl_name );
						if ( ! empty( $pl_vuln_data['vulnerabilities'] ) ) :
							foreach ( $pl_vuln_data['vulnerabilities'] as $item ) {
								$plug_vuln_content .= esc_html( $item['title'] ) . ': ' . esc_html( $item['vuln_type'] ) . '<br/>';
								$plug_vuln_content .= esc_html( $item['detail'] ) . '<br/>';
							}

						endif;
					}
				endif;
			endforeach;

			$theme_vuln_content = '';

			foreach ( $th_results as $th_slug => $data ) :
				$th_slug      = esc_html( $th_slug );
				$show_actions = false;
				$theme_vuln   = $data['vulner_data'];
				$theme_vuln   = json_decode( $theme_vuln, true );
				$theme_name   = '';
				if ( empty( $theme_vuln['parent'] ) ) :
					foreach ( $theme_vuln as $th_name => $th_vuln_data ) {
						$theme_name = esc_html( $th_name );
						if ( ! empty( $th_vuln_data['vulnerabilities'] ) ) :
							foreach ( $th_vuln_data['vulnerabilities'] as $item ) {
								$theme_vuln_content .= esc_html( $item['title'] ) . ': ' . esc_html( $item['vuln_type'] ) . '<br/>';
								$theme_vuln_content .= esc_html( $item['detail'] ) . '<br/>';
							}
						endif;
					}
				endif;
			endforeach;

			$reports_data['vulnerable.plugins']   = $plug_vuln_content;
			$reports_data['vulnerable.themes']    = $theme_vuln_content;
			$reports_data['vulnerable.checkdate'] = ! empty( $last_check ) ? MainWP_Vulnerability_Utility::formatTimestamp( $last_check ) : 'N/A';
		}

		$reports_data['vulnerabilities.count'] = intval( $result['plugin_vulner_count'] ) + intval( $result['theme_vulner_count'] ) + intval( $result['wp_vulner_count'] );

		return $reports_data;
	}


	public static function render_overview_info() {

		$site_id = 0;

		if ( isset( $_GET['page'] ) && 'managesites' == $_GET['page'] ) {
			$site_id = isset( $_GET['dashboard'] ) ? intval( $_GET['dashboard'] ) : 0;
			if ( empty( $site_id ) ) {
				return;
			}
		}

		if ( $site_id ) {
			$result = MainWP_Vulnerability_DB::instance()->get_result_by( 'site_id', $site_id );
		} else {
			$service = MainWP_Vulnerability_Checker::get_enabled_service();
			$result  = MainWP_Vulnerability_Checker::get_all_total_vulner( $service );
		}

		?>

		<div class="ui hidden divider"></div>
		<div class="ui horizontal divider"><?php _e( 'Vulnerabilities', 'mainwp-vulnerability-checker-extension' ); ?></div>
		<div class="ui hidden divider"></div>
		<div class="ui four column stackable grid">
			<div class="column center aligned">
				<div class="ui statistic">
					<div class="label">
						<?php _e( 'WP Core', 'mainwp' ); ?>
					</div>
					<div class="value">
						<?php echo ( $site_id ? $result['wp_vulner_count'] : $result['total_wp_vulner'] ); ?>
					</div>
				</div>
			</div>
			<div class="column center aligned">
				<div class="ui statistic">
					<div class="label">
						<?php _e( 'Plugins', 'mainwp' ); ?>
					</div>
					<div class="value">
						<?php echo ( $site_id ? $result['plugin_vulner_count'] : $result['total_plugin_vulner'] ); ?>
					</div>
				</div>
			</div>
			<div class="column center aligned">
				<div class="ui statistic">
					<div class="label">
						<?php _e( 'Themes', 'mainwp' ); ?>
					</div>
					<div class="value">
						<?php echo ( $site_id ? $result['theme_vulner_count'] : $result['total_theme_vulner'] ); ?>
					</div>
				</div>
			</div>
			<div class="column center aligned middle aligned">
				<a class="ui green basic button" href="<?php echo ( $site_id ? 'admin.php?page=ManageSitesVulnerabilities&id=' . $site_id : 'admin.php?page=Extensions-Mainwp-Vulnerability-Checker-Extension' ); ?>"><?php esc_html_e( 'See Details', 'mainwp-vulnerabilies-checker-extension' ); ?></a>
			</div>
		</div>
		<?php
	}

	public function site_synced( $website, $information = array() ) {

		$settings = MainWP_Vulnerability_Checker::instance()->get_current_service_settings();

		if ( ! is_array( $settings ) || ! isset( $settings['scan_sync'] ) || empty( $settings['scan_sync'] ) ) {
			return;
		}

		$siteid = $website->id;
		$force  = 0;
		MainWP_Vulnerability_Checker::instance()->do_vulner_result_recheck( $siteid, $force );
	}

	public function hook_mainwp_vulner_getvulner( $value, $site_id = null ) {
		$service = MainWP_Vulnerability_Checker::get_enabled_service();
		if ( $site_id ) {
			$result = MainWP_Vulnerability_DB::instance()->get_result_by( 'site_id', $site_id );
			if ( $result ) {
				if ( 'nvd_nist' === $service ) {
					$result = MainWP_Vulnerability_Nvd_Checker::instance()->recalculate_unignored_counting_numbers( $result );
				}
				return $result['wp_vulner_count'] + $result['plugin_vulner_count'] + $result['theme_vulner_count'];
			}
			return $value;
		}

		$result = MainWP_Vulnerability_Checker::get_all_total_vulner( $service );

		if ( is_array( $result ) ) {
			return $result['total_wp_vulner'] + $result['total_plugin_vulner'] + $result['total_theme_vulner'];
		}
		return $value;
	}
} // End of class
