<?php

class MainWP_Vulnerability_Utility { // phpcs:ignore -- NOSONAR - multi methods.


	protected static $instance = null;


	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	// Constructor
	public function __construct() {
	}


	public static function map_site( &$website, $keys ) {
		$outputSite = array();
		foreach ( $keys as $key ) {
			$outputSite[ $key ] = $website->$key;
		}
		return $outputSite;
	}

	public static function get_time_threshold( $schedule = '' ) {
		$threshold = 0;
		if ( $schedule == 'daily' ) {
			$threshold = ( 60 * 60 * 24 );
		} elseif ( $schedule == 'weekly' ) {
			$threshold = ( 60 * 60 * 24 * 7 );
		} elseif ( $schedule == 'monthly' ) {
			$threshold = ( 60 * 60 * 24 * 30 );
		} elseif ( $schedule == 'disabled' ) {
			$threshold = 0;
		}
		return $threshold;
	}

	public static function get_timestamp( $timestamp = false ) {
		if ( false === $timestamp ) {
			$timestamp = time();
		}
		$gmtOffset = get_option( 'gmt_offset' );
		return $gmtOffset ? ( $gmtOffset * HOUR_IN_SECONDS ) + $timestamp : $timestamp;
	}

	public static function formatTimestamp( $timestamp ) {
		return date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $timestamp );
	}


	/**
	 * Debugging log info.
	 *
	 * Sets logging for debugging purpose.
	 *
	 * @param string $message Log info message.
	 */
	public static function log_info( $message ) {
		// Set color: 0 - LOG, 1 - WARNING, 2 - INFO, 3- DEBUG.
		$log_color = 2;
		self::log_debug( $message, $log_color );
	}

	/**
	 * Debugging log.
	 *
	 * Sets logging for debugging purpose.
	 *
	 * @param string $message Log debug message.
	 */
	public static function log_debug( $message, $log_color = 3 ) {
		$cron = '';
		if ( defined( 'DOING_CRON' ) && DOING_CRON ) {
			$cron = 'CRON :: ';
		}
		// Set color: 0 - LOG, 1 - WARNING, 2 - INFO, 3- DEBUG.
		do_action( 'mainwp_log_action', 'Vuln Checker :: ' . $cron . $message, MAINWP_VULNER_CHECKER_LOG_PRIORITY, $log_color );
	}


	/**
	 * Method encrypt_api_keys
	 *
	 * Encrypt data.
	 */
	public function encrypt_api_keys( $data, $siteid = false, $file_key = false, $default = '' ) {
		if ( ! empty( $data ) && is_string( $data ) ) {
			$prefix = 'vulner_';
			if ( ! empty( $siteid ) ) {
				$prefix = $prefix . intval( $siteid ) . '_';
			}
			$result = apply_filters( 'mainwp_encrypt_key_value', false, $data, $prefix, $file_key );
			if ( is_array( $result ) && ! empty( $result['encrypted_val'] ) ) {
				return $result;
			}
		}
		return $default;
	}

	/**
	 * Method decrypt_api_keys
	 *
	 * Encrypt data.
	 */
	public function decrypt_api_keys( $encrypted_data, $default = false ) {
		if ( ! empty( $encrypted_data ) && is_array( $encrypted_data ) && ! empty( $encrypted_data['encrypted_val'] ) ) { // old format.
			$result = apply_filters( 'mainwp_decrypt_key_value', false, $encrypted_data, $default );
			if ( ! empty( $result ) && is_string( $result ) ) {
				return $result;
			}
		}
		return $default;
	}

	/**
	 * Method get_compatible_site_gdev_key
	 *
	 * Encrypt data.
	 */
	public function get_compatible_access_token() {
		$token     = '';
		$encrypted = MainWP_Vulnerability_Wpvulndb_Settings::instance()->get_option( 'encrypted_data' );
		if ( ! empty( $encrypted ) && is_array( $encrypted ) && ! empty( $encrypted['encrypted_val'] ) ) { // encrypted data.
			return $this->decrypt_api_keys( $encrypted, '' );
		} else {
			$token = MainWP_Vulnerability_Wpvulndb_Settings::instance()->get_option( 'access_token' );
			if ( is_string( $token ) && ! empty( $token ) ) { // old format.
				$encrypted = $this->encrypt_api_keys( $token );
				if ( is_array( $encrypted ) && ! empty( $encrypted['file_key'] ) ) {
					$update = array(
						'encrypted_data' => $encrypted,
						'access_token'   => '',
					);
					MainWP_Vulnerability_Wpvulndb_Settings::instance()->update_options( $update );
				}
			}
		}
		return $token;
	}

	/**
     * Method get_common_word
     *
     * @param string $key word key.
     *
     * @return string word string.
     */
    public static function get_common_word( $key ) {
        $words = array(
            'affected-version' => __( 'Affected Version', 'mainwp-vulnerability-checker-extension' ),
            'type'             => __( 'Type', 'mainwp-vulnerability-checker-extension' ),
            'fixed-in-version' => __( 'Fixed in Version', 'mainwp-vulnerability-checker-extension' ),
            'references'       => __( 'References', 'mainwp-vulnerability-checker-extension' ),
            'detected-version' => __( 'Detected version:', 'mainwp-vulnerability-checker-extension' ),
			'invalid-request'  => __( 'Invalid request!', 'mainwp-vulnerability-checker-extension' ),
			'failed'           => __( 'Failed!', 'mainwp-vulnerability-checker-extension' ),
			'published-date'   => __( 'Published Date', 'mainwp-vulnerability-checker-extension' ),
			'detail'           => __( 'Detail', 'mainwp-vulnerability-checker-extension' ),
        );

        return isset( $words[ $key ] ) ? $words[ $key ] : '';
    }
} // End of class
