<?php
if ( ! defined( 'MAINWP_WORDFENCE_PATH' ) ) {
	exit;
}
/**
 * Presents an issue template.
 */


if ( empty( $site_id ) ) {
	$optionsURL = '#';
} else {
	$optionsURL = 'admin.php?page=SiteOpen&newWindow=yes&websiteid=' . $site_id . '&location=' . base64_encode( 'admin.php?page=WordfenceScan&subpage=scan_options#wf-option-other-scanOutside#wf-scanner-options-general' ) . '&_opennonce=' . wp_create_nonce( 'mainwp-admin-nonce' );
}

echo MainWP_wfView::create(
	'scanner/issue-base',
	array(
		'internalType'          => 'skippedPaths',
		'displayType'           => esc_html__( 'Skipped Paths', 'wordfence' ),
		'iconSVG'               => '<svg viewBox="0 0 20 20"><g><path d="M18 16V4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h13c.55 0 1-.45 1-1zM8 11h1c.55 0 1 .45 1 1s-.45 1-1 1H8v1.5c0 .28-.22.5-.5.5s-.5-.22-.5-.5V13H6c-.55 0-1-.45-1-1s.45-1 1-1h1V5.5c0-.28.22-.5.5-.5s.5.22.5.5V11zm5-2h-1c-.55 0-1-.45-1-1s.45-1 1-1h1V5.5c0-.28.22-.5.5-.5s.5.22.5.5V7h1c.55 0 1 .45 1 1s-.45 1-1 1h-1v5.5c0 .28-.22.5-.5.5s-.5-.22-.5-.5V9z"/></g></svg>',
		'summaryControls'       => array( MainWP_wfView::create( 'scanner/issue-control-ignore', array( 'ignoreP' => esc_html__( 'Ignore', 'wordfence' ) ) ), MainWP_wfView::create( 'scanner/issue-control-show-details' ) ),
		'detailPairs'           => array(
			esc_html__( 'Details', 'wordfence' ) => '{{html longMsg}}',
		),
		'detailControls'        => array(
			'<a href="' . esc_url( $optionsURL ) . '" target="_blank" class="wf-btn wf-btn-default wf-btn-callout-subtle">' . esc_html__( 'Go To Option', 'wordfence' ) . '</a>',
			'<a href="#" class="wf-btn wf-btn-default wf-btn-callout-subtle wf-issue-control-mark-fixed" role="button">' . esc_html__( 'Mark as Fixed', 'wordfence' ) . '</a>',
		),
		'textOutput'            => ( isset( $textOutput ) ? $textOutput : null ),
		'textOutputDetailPairs' => array(
			esc_html__( 'Details', 'wordfence' ) => '$longMsg',
		),
	)
)->render();
